package RePEc::Index::Collection::RePEcRec;


use strict;

use base qw( RePEc::Index::Collection::RePEc );

use Carp::Assert;

use RePEc::Index::Collection::RePEc;

use ARDB::Record::ReDIF;

use ReDIF::Parser qw( redif_open_file redif_get_next_template );

ReDIF::Parser::set_parser_options( utf8_output => 1 );


sub get_next_record {
  my $self = shift;

  my $t = redif_get_next_template();

  if( $t
    and $t->{ID} ) {
    $t->{ID} = lc $t->{ID};
    bless $t, 'ARDB::Record::ReDIF';
    return ( $t->{ID}, $t, $t->{'template-type'}[0], $t->{STARTFPOS}, $t->{MD5SUM} );

  } else {
    return undef;
  }
}


sub make_monitor_file_checker { 
  return sub { 
    if ( m/\.rdf$/i ) {  return 1; }
    else { return 0; }
  }
}

sub make_monitor_dir_checker { 
  return sub {
    if (    m!^all$! 
         or m!^[a-z]{3}(/[a-z\d]{6})?$!i 
         or m!^edi(/inst)?$!i 
         or m!^(per|ras)(/pers)?$! ) { return 1; }

    return 0;
  }
}



1;
