
package RePEc::Index::Collection;


use strict;


sub new {
  my $class = shift;

#    my $collection = $class -> new( $dir, $type, $prefix, $index_dir, \%options );

  my $home      = shift;
  my $type      = shift;
  my $prefix    = shift;  ## authority handle prefix
  my $index_dir = shift; 
  my $options   = shift;


  my $self = {
              home   => $home,
              type   => $type,
              prefix => $prefix,
              id     => $prefix,
              db     => {
                      },
              index_dir => $index_dir, 
              options => $options,
              
             };

  $self->{db}{files    } = $index_dir . '/files';
  $self->{db}{conflicts} = $index_dir . '/conflicts';
  $self->{db}{records  } = $index_dir . '/records';
  $self->{db}{history  } = $index_dir . '/history';

  if ( $options->{proc} ) {

    my @out = split '\+', $options->{proc};
    foreach my $proc ( @out ) {
      for ( $self->{proc} ) {
#       warn "Collection proc: $proc";
        if ( ref $_ ) { $_ = [ $proc ]; } 
        else {         push @$_, $proc; }
      }
    }
  }

  return bless $self, $class;
}



sub id   { $_[0]->{id  }; }

sub type { $_[0]->{type}; }


sub check_id { return 1; }

sub monitor_file_checker {
  my $self = shift;
  if ( not $self ->{monitor_file_checker} ) {
    $self ->{monitor_file_checker} = $self ->make_monitor_file_checker;
  } 

  return $self ->{monitor_file_checker};
}


sub monitor_dir_checker {
  my $self = shift;
  if ( not $self ->{monitor_dir_checker} ) {
    $self ->{monitor_dir_checker} = $self ->make_monitor_dir_checker;
  } 
  
  return $self ->{monitor_dir_checker};
}


sub make_monitor_file_checker {
  my $self = shift;
  return sub { return 1; }
}

sub make_monitor_dir_checker {
  my $self = shift;
  return sub { return 1; }
}



1;

