package RePEc::Index;
# $Id: Index.pm,v 2.1 2006/03/15 10:41:39 ivan Exp $

######  still to document data object interface !!!!!!!!


=pod

=head1 NAME

RePEc::Index - access to the ReDIF/RePEc data indices

=head1 SYNOPSIS

    use RePEc::Index 'RePEc';

    #  get a template 
    my $template = RePEc::Index -> lookup_record ( $handle );

    #  get template's history
    my $history  = RePEc::Index -> lookup_history ( $handle );

    #  get a file's info.
    #  relative to the collections' root dir
    my $file     = RePEc::Index -> lookup_file ( "aah/aarhec/" );

    my $records  = $file->templates_list();

    foreach ( @$records ) {
       my $rec = RePEc::Index->lookup_record( $_ );
       ...
    }

    #  get collection's root listing
    my $root     = RePEc::Index -> lookup_file ( "" );

    my $files = $root -> files_list();

    foreach ( @$files ) {
      # check for the trailing slash "/"
      if( $_ =~ m!/$! ) {
         print " dir: $_\n";
      } else {
         print "file: $_\n";
      }
    }


    # selecting another collection by name
    RePEc::Index->select_collection ( 'rclis' );

=cut
    
$VERSION = "0.34";

use strict;

use Carp::Assert;

use Storable qw( thaw store retrieve ); 


use vars qw( $TEMPLATE_CLASS $FILE_CLASS $DIR_CLASS
             $DATA_DIR $COLLECTIONS 
             $DEFAULT_COLLECTION $UPDATE_OBJ $HOME 
             %COLLECTIONS @COLLECTION_IDS
           );

###
###  $HOME variable is to set configuration externally
###

use RePEc::Index::Config;
use RePEc::Index::Update;

use RePEc::Index::Storage
  qw(
     &load_record_from_db 
     &open_dbfile
    );


### some tools prepared 

use RePEc::Index::Log;

RePEc::Index::Storage::set_log ( 'RePEc::Index::Log' );

sub log_it {
    RePEc::Index::Log::log( @_ );
}

sub error   { log_it( 8, @_ ); }

sub warning { log_it( 6, @_ ); }


### some initializations

# if( scalar( keys %$COLLECTIONS ) == 1 ) {
#   __PACKAGE__ -> select_collection ( keys %$COLLECTIONS );
# }

sub import {
  shift;
  my $collection = shift;
  
  if( $collection ) {
    __PACKAGE__ -> select_collection ( $collection );
    print "Selecting collection: $collection\n";
  }
}


####  special data records preparations

my ( %DATA );

$TEMPLATE_CLASS = "RePEc::Index::TEMPLATE";
$FILE_CLASS     = "RePEc::Index::FILE";
$DIR_CLASS      = "RePEc::Index::DIR";

my @TEMPLATE_RECORD = 
    qw( handle first_observed last_observed valid 
        present filename redif_type md5digest object );

my @FILE_RECORD = 
    qw( filename first_observed last_observed last_changed last_read
        templates_list present last_modified );

my @DIR_RECORD = 
    qw( filename first_observed last_observed files_list present );


&prepare_record_classes () ;



=pod 

=head1 DESCRIPTION

The module provides access to the complete database of RePEc templates
and RePEc files metadata.

=head2 FUNCTIONS

=over 4

=cut

=item -> select_collection ( COLLECTIONNAME )

This prepares the module to provide data from collection
COLLECTIONNAME.  The collection must be defined in the collections
configuration.

Returns true on success.

=cut

sub select_collection {
  my $module = shift;
  my $collection = shift;

  assert( $collection );
  
#  warn "Collection: $collection\n";
  
  if( $collection 
      and exists $COLLECTIONS->{$collection} ) {

    $DEFAULT_COLLECTION = $collection;
    $UPDATE_OBJ = RePEc::Index::Update-> new( $collection );

    die if not $UPDATE_OBJ;
    return 1;
  }

  die;
  return undef;
}



sub get_collection_for_id { 
  my $id = shift;

  my $collections = \@RePEc::Index::COLLECTION_IDS;
  my $collections_hash = \%RePEc::Index::COLLECTIONS;

  foreach ( @$collections ) {
    my $prelen = length ( $_ );
    if ( substr( $id, 0, $prelen ) eq $_ ) {
      return $collections_hash -> { $_ };
    }
  }
}


=item -> lookup_record ( ID )

Look-up the record data in the collections' records database and
return it.

Returns undef on error or if there's no such record in the database.

=cut

sub lookup_record {
  my $module = shift;
  my $id     = shift;

  my $coll = get_collection_for_id( $id );


  # is there a conflict on the record id?

  my $cdb = open_dbfile( $coll->{db}{conflict}, 'write' );
  if ( $cdb->{$id} ) {
    return undef;
  }


  # do we keep the records_db for this collection?

  if( not defined $coll->{db}{records} ) {
    return undef;
  }


  # now go get the object!

  my $rec_db = $coll->{db}{records};
  
  my $rt = load_record_from_db( $id, $rec_db );
  if( ref( $rt) eq 'ARRAY' ) {
    return @{ $rt }; 
  } else {
    return $rt;
  }

}


=item -> lookup_history ( ID )

Look-up the record's history data in the collections' history database
and return it.

Returns undef on error or if there's no such record in the database.

=cut

sub lookup_history {
  my $module = shift;
  my $id     = shift;

  my $coll = get_collection_for_id( $id );

  my $his_db = $coll->{db}->{history};
  
  return load_record_from_db( $id, $his_db );
}




# =item -> lookup_file ( NAME )

# Look-up a file or directory named NAME data in the collections' files
# database and return it.

# Returns undef on error or if there's no such file in the database.

# =cut

sub lookup_file {
  my $module = shift;
  my $id     = shift;

  assert( $UPDATE_OBJ );

  my $files_db = $UPDATE_OBJ->{files_db};
  assert( $files_db );

  return load_record_from_db( $id, $files_db );
}


# =item -> check_status () [OBSOLETE]

# This function checks the index database status by means of a special
# file, which is always updated during (and after) a database update.
# The file contains some simple general information about the database.
# The function is just for the client's information: checking it is not
# obligatory.  Returns TRUE on good status.  FALSE result does not mean
# that operations are not possible, it will just mean that the last
# database update has not been succesfully finished, or that there's no
# initial database at all.

# =cut

# sub check_status {
#     shift;
# }



###############################################################################

=item -> create_new_template_record () [OBSOLETE]

This function returns empty blessed template record object.

=cut

sub create_new_template_record {
    my $template = [];
    bless $template, $TEMPLATE_CLASS;
}

###############################################################################

=item -> create_new_file_record ()

This function returns empty blessed file record object.

=cut

sub create_new_file_record {
    my $file = [];
    bless $file, $FILE_CLASS;
}

###############################################################################

=item -> create_new_dir_record ()

This function returns empty blessed dir record object.

=cut

sub create_new_dir_record {
    my $file = [];
    bless $file, $DIR_CLASS;
}




###############################################################################
###  sub  PREPARE RECORD CLASSES  #############################################
###############################################################################

###   Preparing record data types (classes)

sub prepare_record_classes {
    prepare_data_class(   $TEMPLATE_CLASS,  \@TEMPLATE_RECORD   );
    prepare_data_class(   $FILE_CLASS,      \@FILE_RECORD       );
    prepare_data_class(   $DIR_CLASS,       \@DIR_RECORD       );
}



###############################################################################
###  sub   PREPARE DATA CLASS   ###############################################
###############################################################################

###   Here we define a class of data record with necessary
###   configuration of the data field names.

sub prepare_data_class {

    no strict;

    my $class = shift;
    my $fields = shift;

    @{ $class . '::FIELDS' } = @$fields ;
    @{ $class . '::ISA' } = ( 'RePEc::Index::RECORD_BASE' ) ; 

    my $hash = {};

    my $i = 0;
    foreach my $f ( @$fields ) {
        die if exists $hash->{$f};
        $hash -> {$f} = $i ;

###     warn "Defining $f (in $class)\n";

        ###  simple get-type accessor method
        eval " sub ${class}::$f { my \$obj = \$_[0]; \$obj -> [$i] } ";

        ###  simple set-type accessor method
        eval " sub ${class}::${f}_set { my \$obj = \$_[0]; " . 
                    " \$obj -> [$i] = \$_[1]; } ";
        $i ++;
    }

    eval " sub ${class}::_fields { return \\\@{${class}::FIELDS}; } " ;

    ${ $class . '::HASH' } = $hash;

}


###############################################################################


{

###   Here we define some additional basic behavior for the data record objects

    package RePEc::Index::RECORD_BASE;

    use Storable qw( freeze ); 
    
    sub _serialize { 
        my $obj = shift;
        return freeze( $obj );
    }

    sub _visualize {
        my $obj = shift;
        my $fields = $obj -> _fields;  

        my $i;
        foreach my $f ( @$fields ) {
            $f = ucfirst $f;
            $f =~ s/_/ /g;

            my $v = $obj ->[$i];
            if( ref( $v ) eq 'ARRAY' ) {
                $v = join ", ", @$v;
            }
            printf "%27s: %s\n", $f, $v;
            $i++;
        }

    }

}



# 2005-03-10 13:20
# database checking (recovery) functions

sub check_and_prepare_db {
  my $datadir = $RePEc::Index::Config::DATADIR;

  if ( not -r $datadir or not -d _ ) {
    return undef;
  }
  
  return RePEc::Index::Storage::prepare_for_work( $datadir );
}




1;

__END__




