#!/bin/bash

###  RePEc-Index to ACIS installation 

###  preamble:

if test -z $1; then 
    echo give a destination directory name as in:
    echo $0 /some/dir
    exit 1
fi

dest=$1

self=$0
selfdir=${self%/install.sh}

if test $selfdir = $0; then 
    selfdir=.
fi

if test -z $selfdir; then 
    echo some error: can\'t find out installation package own directory
    echo but probably it is just current directory: `pwd`
    exit 1
fi

cd $selfdir
src=`pwd`


if test -d $dest; then
   upgrade=1
   echo "this is an upgrade"
else 
   upgrade=
   echo "You don't even yet have that directory: $dest"
   mkdir $dest
fi

cd $dest
dest=`pwd`

echo "installing to $dest directory"


if test -z $dest; then 
    echo "Can't get absolute path to $1"
    exit 1
fi



cd $src


###  installation

cp -r lib/* $dest/lib/
cp control_daemon.pl request_update.pl reindex.pl $dest/bin/

$dest/bin/setup
