

use Carp::Assert;

use RePEc::Index::History::Handle;

my $script = [];

while( <DATA> ) {
  next if /^\s*$/;

  s/(^\s+|\s+$)//g;

  my ( $command, @params ) = split /,\s/, $_;

  next if not $command;

  foreach ( @params ) {
    s/^"(.*)"$/$1/;
  }
  push @$script, [ $command, @params ];  
}


foreach ( @$script ) {
  my $command = shift @$_;
  my @params  = @$_;

  $command =~ s/\s/_/g;
#  print "command: $command\n";
  &{ $command } ( @params );
}

my $obj;
my @result ;

sub create {
  my $handle = shift;
  $obj = RePEc::Index::History::Handle -> new( $handle );
  print "created: $obj\n";
}

sub session {
  my $time = shift;
  $obj -> update_session_time( $time );
  print "set session time: $time\n";
}

sub present {
  my ($f, $p, $cs)  = @_;

  assert( $f  );
  assert( $p  );
  assert( $cs );

  @result = $obj -> present( $f, $p, $cs );
  print "present event: returned: ", join ", ", @result; 
  print "\n";
}

sub show_status {
  use Data::Dumper;

  print "object: status:\n";
  print Data::Dumper->Dump( [$obj->status()], [ 'status' ] );
}

sub show_history {
  use Data::Dumper;

  print "object: history:\n";
  print Data::Dumper->Dump( [$obj->history()], [ 'history' ] );
}


sub show_pending_files {
  print "files to check: [ "; 
  my $f = $obj->{files_to_check};
  print join ', ', @$f;
  print " ]\n";
}

sub lost_template {
  my $f = shift;
  my $p = shift;
  
  $obj-> lost_template( $f, $p );
}

sub lost_file {
  my $f = shift;
  
  $obj-> lost_file( $f );
}



sub AUTOLOAD {
  
}

1;

__DATA__
create, RePEc:ixa:fgrsta:3439
session, 23000000
present, "ixa/fgrsta/1.rdf", 200, "CHECKSUM001"
show status
show history
session, 23000100
present, "ixa/fgrsta/2.rdf", 30, "CHECKSUM001"
show pending files
lost template, "ixa/fgrsta/1.rdf", 200
show status
show history
show pending files
session, 23000200
present, "ixa/fgrsta/2.rdf", 30, "CHECKSUM001"
present, "ixa/fgrsta/3.rdf", 50, "CHECKSUM002"
show status
session, 23000300
present, "ixa/fgrsta/3.rdf", 50, "CHECKSUM002"
lost file, "ixa/fgrsta/2.rdf"
show status
show history
show pending files
session, 23000400
present, "ixa/fgrsta/3.rdf", 70, "CHECKSUM003"
show status
show history
show pending files


