package RePEc::Index::ShortIDs;

#  This perl module is part of RePEc-Index system.  This module is
#  responsible for passing templates to the
#  ARDB::Plugin::Output::ShortHandles module, so that it writes out the
#  person templates, enriched with the magically-generated short IDs.

#  Copyright (c) 2002 Ivan Kurmanov, RePEc project.  All rights
#  reserved.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#

use strict;
use Carp qw( cluck );
use Carp::Assert;

use RePEc::Index;
use RePEc::Index::Config;
use RePEc::Index::Log;

sub log_it {
    RePEc::Index::Log::log( @_ );
}

sub error   { log_it( 8, @_ ); }

sub warning { log_it( 6, @_ ); }


my $DATADIR = $RePEc::Index::Config::DATADIR;
my $SOURCEDIR = $RePEc::Index::Config::SOURCEDIR;

use ARDB::Plugins::Output::ShortHandles;

my $plugin = ARDB::Plugins::Output::ShortHandles -> new();

$plugin -> init ();

sub process_template {
  my $template = shift;

  if ( $template->{'template-type'} [0] =~ /Person/ ) {
    $plugin -> process_record ( $template );
  }
}


# the end of RePEc::Index::ShortIDs;

1;

__END__
