package RePEc::Index::Collection::AMF;


use strict;
use Carp::Assert;

use base qw( RePEc::Index::Collection );
use RePEc::Index::Collection;

use AMF::Parser;


sub open_data_file {
  my $self = shift;
  my $file = shift;

  return amf_open_file $file;
}


sub get_next_record {
  my $self = shift;

  my $r;
  
  START: $r    = amf_get_next_record;

  if ( $r ) {

    my $id   = $r ->id;

    if ( not $id ) { goto START; }

    my $type = $r ->type;
    my $start = 0;
    my $md5  = $r -> md5checksum;

    return ( $id, $r, "amf:$type", $start, $md5 );

  } else {
    return undef;
  }
}

#sub check_id {
#  return 1;
#}


sub make_monitor_file_checker { 
  return sub { 
    if ( m/\.amf\.xml$/i ) {  return 1; }
    else { return 0; }
  }
}

#sub make_monitor_dir_checker { 
#  return sub { return 1; }
#}



1;
