use ARDB::Test;

eval " use ARDB::ObjectDB; ";

test not( $@ ), $@ ;


################# package Obb ###################
package Obb;

sub new {
  my $class = shift;  
  return bless { @_ }, $class;
}

sub id {
  my $self = shift;
  return $self->{id};
}

sub print {
  my $self = shift;

  print "object $self:\n";
  foreach ( keys  %$self ) { 
    print "  ", $_, ": '", $self->{$_}, "'\n";
  }  
}

################## end of Obb ####################

package main;

my $id;
my $dbfile = "t/object.db";

unlink $dbfile;

{
  my $o = eval { 
    ARDB::ObjectDB::retrieve_record( $dbfile, $id );
  };

  test $@;
}

{
  my $obj  = Obb->new( id=> 'big-box', type => 'container' );

  test $obj;
  test $obj->id;

  $id = $obj->id;

  $obj->print();

  test ARDB::ObjectDB::store_record( $dbfile, $obj );
}

{
  my $o = ARDB::ObjectDB::retrieve_record( $dbfile, $id );
  test $o;
  test $o -> id;
  test $o -> {type};
  $o->print;
}

ARDB::ObjectDB::delete_record( $dbfile, $id );

{
  my $o = ARDB::ObjectDB::retrieve_record( $dbfile, $id );
  test not $o;
}

