# -*- Mode:perl -*-

use strict;

use ARDB::Test;

eval " use ARDB; ";

test not( $@ ), $@ ;

$ARDB::DEBUG = 1;
use ARDB;

my $ardb = ARDB -> new( "home" );

test $ardb;


my $sql = $ardb->{sql_object};

$sql -> prepare( 'select * from relations limit 10' );

my $res = $sql -> execute ();

test $res;

for ( 1..10 ) {

  my $subj = $res->get( 'subject'  );
  my $obj  = $res->get( 'object'   );
  my $rel  = $res->get( 'relation' );
  my $src  = $res->get( 'source'   );

  test $subj, "$subj -> $obj / $rel from $src";
  $res->next;

}



