#!/usr/local/bin/perl

###   This is a script for the RePEc::Index module.  

use Events;

use RePEc::Iterator;

use strict;

my $repec_directory = '/home/ivan/data/RePEc';
my $authority = "RePEc";

my $Session_Time = time ();   ######    !!!!!!!!!!

Events-> register_event_handler( 'REPEC::ITERATOR::*',  
'my ($s) = ($_[0] =~ m/^REPEC::ITERATOR::(.+)/); print STDERR "$s: ", $_[1], "\n"; ');

Events->register_event_handler( 'REDIF::ARCHIVE::STARTED', \&archive_started);
Events->register_event_handler( 'REDIF::ARCHIVE::FINISHED',\&archive_finished);

# Events-> register_event_handler( 'REDIF::FILE::*',     \& print_event );
# Events->register_event_handler( 'REDIF::FILE::*', \&redif_file_handler );
Events->register_event_handler( 'REDIF::FILE::ARCHIVE',\&redif_file_handler );
Events->register_event_handler( 'REDIF::FILE::SERIES', \&redif_file_handler );
Events->register_event_handler( 'REDIF::FILE::NORMAL', \&redif_file_handler );


Events-> register_event_handler( 'REDIF::ARCHIVE::STARTED', \& print_event );
# Events-> register_event_handler( 'REDIF::ARCHIVE::STARTED', \& print_event );
# Events-> register_event_handler( 'REPEC::ITERATOR::?',  \& print_event );

sub print_event {
    my $event = shift;
    $event =~ s/::/ /g;
    print "EVENT: $event  [ ", join ( ', ', @_ ), " ] \n";
    return 1;
}

# Events-> register_event_handler( 'REDIF::FILE::NORMAL',
#  ' $::files++; print "*"; '  );

Events-> register_event_handler( 'REDIF::ARCHIVE::FINISHED',  
'print "Archive finished ($::ARCHIVE_NAME): $::files\n"; $::files = 0; '.
'print "File-records stored: $::stored_files\n"; $::stored_files = 0; '  );

$::files = 0;
$::stored_files = 0;

RePEc::Iterator::main ( $repec_directory, $authority );

RePEc::Index -> store_index_dat ( 
				  { 
				      LAST_UPDATE => $Session_Time , 
				      OK => 1, 
				  } 
				  );


print "Saved Index db status. update timestamp: $Session_Time\n";

###############################################################################

use RePEc::Index;

use Carp::Assert;

use vars qw( $ARCHIVE_NAME );

my %ARC_FILES;

########

sub archive_started {
    $ARCHIVE_NAME = $_[1];
    %ARC_FILES = ();

}

########

sub archive_finished {

    my $hash = RePEc::Index -> iterate_archive_files( $ARCHIVE_NAME );

###    print "lost files check\n";
    while(  my $file = each ( %$hash )  ) {
	if( not $ARC_FILES{$file} ) {
###	    print "File not present: $file\n";
	    ####### !!!!!!!
	} else {
###	    print "file $file confirmed\n";
	}
    }

}

########

sub redif_file_handler {

    my $filename = $_[1];
    my $short_filename = $_[2];

    print "file $short_filename: ";

    my $record = RePEc::Index 
          	-> look_up_file ( $short_filename, $ARCHIVE_NAME );

    die "Double file ($short_filename)" if ( $ARC_FILES{$short_filename} );
    $ARC_FILES{$short_filename} = 1;

    my $readfile = 0;

    if ( not defined $record ) {

	print "NEW\n";

	$record = RePEc::Index -> create_new_file_record ();
	$record -> filename_set ( $short_filename );
	$record -> first_observed_set ( $Session_Time );
	$record -> templates_list_set ( [] );
	$record -> present_set ( 1 );
	$record -> last_observed_set ( $Session_Time );
	
	$readfile = 1;

    } else {

	if ( -e $filename ) {

	    my $mark = $record -> last_observed ();
	    if ( ( stat $filename ) [9] > $mark ) {
		### file has changed since last update
		print "OLD / CHANGED\n";
		$record -> last_changed_set ( $Session_Time );
		
		$readfile = 1;
	    } else {
		print "OLD / UNCHANGED\n";
	    }
	    
	    $record -> present_set ( 1 );
	    $record -> last_observed_set ( $Session_Time );
	    

	} else {
	    print "OLD / DELETED";
	    $record -> present_set ( 0 );
	}
    }

    if( $readfile ) {

	my $handles_expected = $record -> templates_list(); 
	my @handles; 
	my %handles;
	
	use ReDIF::Parser;
	&ReDIF::Parser::open_file( $filename );
	
	my $t;
	while( $t = ReDIF::Parser::get_next_template() ) {
	    my $ha = $t->{handle}[0];

	    push @handles, $ha;
	    $handles{$ha} = 1;
	    
	    my $hr = RePEc::Index -> look_up_handle( $ha );

	    my $type = $t->{'template-type'}[0];

	    if( not defined $hr ) {
		$hr = RePEc::Index -> create_new_template_record();
		$hr -> handle_set( $ha );
		$hr -> first_observed_set( $Session_Time );
	    }
	    $hr -> object_set( $t );
	    $hr -> present_set( 1 );
	    $hr -> filename_set( $short_filename );
	    $hr -> redif_type_set( $type );
	    $hr -> last_observed_set( $Session_Time );

	    my $OK = RePEc::Index -> store_template_record ( $hr );
	    if ( $OK ) { $::stored_files ++; }
	    else { warn "Template storage operation failed"; };
	    
	}
	$record -> templates_list_set( \@handles );

	### also need to set as absent the older templates
    }


    my $OK = RePEc::Index -> store_file_record ( $record, $ARCHIVE_NAME );
    if ( $OK ) { $::stored_files ++; }
    else { warn "Storage operation failed"; };
    return 0;
}    

__END__






