package ARDB::UpdateRequest;

use Socket;
use strict;
use warnings;

use ARDB::Common;
use ARDB::SiteConfig;

sub send
 {
  my $request_ref = shift;
  
  my $config = ARDB::SiteConfig -> new;
  my $path =  $config -> daemon_socket;

  socket ( Client, PF_UNIX, SOCK_STREAM, 0 )
   or die "unable to create socket: $!";

  connect ( Client, sockaddr_un ( $path ) )
   or die "unable to connect: $!";

  $| = 1;

  foreach my $key ( keys %{ $request_ref } )
   {
    print Client $key, " ", $request_ref -> {$key}, "\n";
   }

  print Client "\n";

  log_info "requested for update";

  close Client;
 }

# function send receive hash reference, and sends it to control daemon
# request format: <request-string-1> <request-string-2>, separated by
# "\n" symbol
# request-string format: <key> <space> <value>
# finally request end with two "\n" symbols or empty string
#

1;