package ARDB::RecordTypeDB;

use strict;

use BerkeleyDB;

use ARDB::LocalConfig;
use ARDB::Common;

sub new
 {
  my $class   = shift;
  my $db_path = shift;
  
  my $db_env => new BerkeleyDB::Env
   (
    -Home => $ARDB::LocalConfig::local_path,
    -ErrFile => "db.err",
    -Verbose => 1
   );
  
  my $self =
   {
    db => new BerkeleyDB::Hash
     (
      -Filename => $db_path,
      -Flags    => DB_CREATE,
      -Env      => $db_env
     )
   };
  
  die "Cannot open file $db_path: $! $BerkeleyDB::Error\n"
   unless defined $self -> {db};

  log_info ( "connected to record types db" );

  bless $self, $class;
   
  return $self;
 }

sub store_id
 {
  my $self = shift;
  my $id   = shift;
  my $type = shift; 

  log_info ( "stored '$id/$type' in record types db" );
  $self -> {db} -> db_put ( $id, $type );
 }

sub retrieve_type
 {
  my $self = shift;
  my $id   = shift;

  my $type;

  
  my $failure = $self -> {db} -> db_get ( $id, $type );

  if ( $failure )
   {
    critical ( "can't retrieve '$id' in record types db" );
   }

  log_info ( "retrieved '$id/$type' in record types db" );
  return $type;
 }

sub delete_id
 {
  my $self = shift;
  my $id   = shift;

  $self -> {db} -> db_del ( $id );
 }

1;
