package ARDB::Plugin::Input::HTS;

use strict;
use RePEc::Index;
use ARDB::Plugin::Input;

use vars qw( @ISA );

@ISA = ( "ARDB::Plugin::Input" );

sub status
 {
  my $self = shift;

  my $status = RePEc::Index -> check_status ();

  return $status;
 }

sub get_prefixes
 {
  my $self = shift;

  return ['RePEc:'];
 }

sub get_record
 {
  my $self   = shift;
  my $handle = shift;

  my $record = RePEc::Index -> look_up_handle ( $handle );
  return $record -> object()
   if ( defined ( $record ) );

  return undef;
 }

1;

=head1 NAME

ARDB plugin Input::HTS - interface to a RePEc::Index module

=head1 DESCRIPTION

Input::HTS - plugin     
RePEc::Index.    ARDB::Plugin::Input  
3  - status, get_prefixes, get_record.

=head1 AUTHOR

Ivan Baktcheev, with support from Ivan Kurmanov

=head1 SEE ALSO

L<ARDB::Plugins> L<ARDB::Plugin::Input> and L<RePEc::Index>

=cut
 
