package ARDB::ObjectDB;

# This is a module, which will be responsible for storing and loading
# the metadata objects into/from a Berkeley DB, using Storable.

use strict;

use Carp::Assert;

use ARDB::Record; # ?

use RePEc::Index::Storage qw( save_record_to_db load_record_from_db delete_record_from_db );

RePEc::Index::Storage::set_log( 'ARDB::Common' );

use ARDB::Common;

my %loaded;

my %stored;

sub store_record {
  my $dbfn = shift;
  my $rec  = shift;

  assert( $dbfn );
  assert( $rec );

  my $id = $rec->id;

#  warn "storing: $id";

  if( $stored{$id} ) {
    assert( 0 );
  } else {
    $stored{$id} = 1;
  }

  return save_record_to_db( $rec, $dbfn, $id );
}

sub retrieve_record {
  my $dbfn = shift;
  my $id   = shift;

  assert( $dbfn );
  assert( $id );

  my $rec = load_record_from_db( $id, $dbfn );
  
  if (defined $rec) {
    my $class = ref( $rec ) ;
    
    if (not exists $loaded{$class}) {
      eval " use $class; ";
      $loaded{$class} = 1;
    }
  } 
  
  return $rec;  
}


sub delete_record {
  my $dbfn = shift;
  my $id   = shift;

  return delete_record_from_db( $id, $dbfn );
}


1;

__END__

sub new {
  my $filename = shift;
  my $self = {
	      file => $filename, 
	      modu
