#!/bin/bash

if test -z $1; then 
    echo give a destination directory name as in:
    echo $0 /some/dir
    exit 1
fi


dest=$1

src=`pwd`


if test -d $dest; then
   upgrade=1
   echo "this is upgrade"
else 
   upgrade=
   echo "You don't even yet have that directory: $dest"
   mkdir $dest
fi

cd $dest
dest=`pwd`

echo "installing to $dest directory"


if test -z $dest; then 
    echo "Can't get absolute path to $1"
    exit 1
fi



cd $src
cp -r home/presentation $dest/
cp home/screens.xml $dest/
cp -r lib/* $dest/lib/
# cp -r configuration.xml.Fire $dest/
cp -r home/plugins $dest/


###  And now I need to take all home/bin/ scripts and adapt them to the
###  home directory (i mean $dest)


for i in home/bin/*; 
do
    name=${i##*/}
    destname="$dest/bin/$name"
    echo "installing $i to $destname"
#    echo sed -e "s!^homedir=\$!homedir=$dest!" 
    cat $i | sed -e "s!^homedir=\$!homedir=$dest!" > $destname
done

