<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

  <xsl:import href='../general/pages.xsl'/>
  
  <xsl:template match='/data'>
    <xsl:call-template name='page'>

      <xsl:with-param name='title'>welcome</xsl:with-param>

      <xsl:with-param name='content' xml:space='preserve'>
        
        <xsl:call-template name='registered-user-page-header'/>
        
        <h1><xsl:value-of select='$record-name'/> record:</h1>
        
        <xsl:call-template name='show-status'/>
        
        <p>Choose one of the following to edit the record:</p>
        
        <xsl:call-template name='user-menu'/>

        <p>In addition to that, you can:</p>

        <ul>

          <li>see <a
          href='{$base-url}/profile-overview!{$session-id}'>profile overview</a></li>

          <li><a href='{$base-url}/off!{$session-id}'>log off</a></li>

          <li><a href='{$base-url}/unregister!{$session-id}'
          >delete your account</a></li>
   
        </ul>

        
        <xsl:call-template name='registered-user-page-footer'/>

      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  
  
</xsl:stylesheet>
