<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes='exsl'
 version="1.0">

  <xsl:import href='../general/pages.xsl'/>


  <xsl:template match='/'>

    <xsl:variable name='amount' select='count(//session-list/list-item)'/>


    <xsl:call-template name='page'>
      <xsl:with-param name='title'>open sessions</xsl:with-param>

      <xsl:with-param name='content'>
        
        <h1>open sessions</h1>

        <xsl:if test='$amount'>
          <ul>
            <xsl:for-each select='//session-list/list-item'>
              
              <li><a href='{$base-url}/adm/session?id={id}'
              ><xsl:value-of select='id'/></a>, (age: <xsl:value-of
              select='round( number(diff/text()) div 60 )'/> minutes)
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>

      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>


</xsl:stylesheet>

