<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='general/pages.xsl'/>


  <xsl:template name='personal-profile' xml:space='preserve'>
    <xsl:param name='person'/>

    <h1><xsl:value-of select='$person/full-name'/></h1>


    <xsl:if test='$response-data/photo/url'>
      <div class='photo'>

        <h2>Photo</h2>

        <img src='{$response-data/photo/url}' alt='picture of {$person/full-name}' class='photo'/>
        
      </div>
    </xsl:if>

    <h2>Names</h2>

    <table>
      <tr>
        <td class='fld'>first:</td>
        <td class='val'><xsl:value-of select='$person/name/first'/></td>
      </tr>
      <xsl:if test='$person/middle-name/text()'>
        <tr>
          <td class='fld'>middle:</td>
          <td class='val'><xsl:value-of select='$person/name/middle'/></td>
        </tr>
      </xsl:if>
      <tr>
        <td class='fld'>last:</td>
        <td class='val'><xsl:value-of select='$person/name/last'/></td>
      </tr>
    </table>

    
    <xsl:if test='$person/mail-pub or $person/homepage or $person/phone or $person/postal'>
    
    <h2>Contact</h2>

    <table>

      <xsl:if test='$person/mail-pub/text()'>
        <tr>
          <td class='fld'>email:</td>
          <td class='val'><a href='mailto:{$person/email}'><xsl:value-of select='$person/email'/></a></td>

          <!--
          <td class='val'><xsl:call-template name='email'><xsl:with-param name='address' select='$person/email'/></xsl:call-template></td>
-->
        </tr>
      </xsl:if>

      <xsl:if test='$person/homepage/text()'>
        <tr>
          <td class='fld'>homepage:</td>
          <td class='val'><a href='{$person/homepage}'><xsl:value-of select='$person/homepage'/></a></td>
        </tr>
      </xsl:if>
      
      <xsl:if test='$person/phone/text()'>
        <tr>
          <td class='fld'>phone:</td>
          <td class='val'><xsl:value-of select='$person/phone'/></td>
        </tr>
      </xsl:if>

      <xsl:if test='$person/postal/text()'>
        <tr>
          <td class='fld'>postal address:</td>
          <td class='val'><xsl:value-of select='$person/postal'/></td>
        </tr>
      </xsl:if>
      
    </table>

  </xsl:if> <!-- if we have any contact info -->

    <xsl:if test='$response-data/affiliations/list-item'>

      <h2>Affiliations</h2>

      <ul class='institutions'>
<xsl:apply-templates select='$response-data/affiliations'/>
      </ul>

    </xsl:if>





    <xsl:if test='$person/sci-fields/text()'>
      <h2>areas of interests</h2>

<pre><xsl:value-of select='$person/sci-fields/text()'/>
</pre>

    </xsl:if>




  </xsl:template>




 <xsl:template match="*" mode='organization-details'>
<xsl:if test='text()' xml:space='preserve'
>    <li><xsl:value-of select='local-name(.)' />: <xsl:value-of select='text()'/></li>
</xsl:if>
 </xsl:template>



 <xsl:template match='affiliations/list-item|items/list-item' xml:space='preserve'>
  <li class='institution'>
   <xsl:choose
   ><xsl:when test='homepage/text()'
   ><a href='{homepage/text()}'><xsl:value-of select='name/text()'/></a
   ></xsl:when
   ><xsl:otherwise><xsl:value-of select='name/text()'/></xsl:otherwise
   ></xsl:choose>
   <small>
   <ul>
    <xsl:if test='name-english/text()'
      ><li>English name: <xsl:value-of select='name-english/text()' /></li></xsl:if>

    <xsl:if test='email/text()'
      ><li>email: <a href='mailto:{email}'><xsl:value-of select='email/text()' /></a></li></xsl:if>

    <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
   </ul></small>
  </li>
 </xsl:template>



  <!-- /data page template for the outside-visible-profile case -->
  
  <xsl:template match='/data'>

    <xsl:variable name='person' select='$response-data/record'/>

    <xsl:call-template name='page'>
      <xsl:with-param name='title'><xsl:value-of select='$person/full-name'/></xsl:with-param>
      <xsl:with-param name='content' xml:space='preserve'>

        <xsl:call-template name='personal-profile' xml:space='default'>
          <xsl:with-param name='person' select='$person'/>
        </xsl:call-template>

        
        <xsl:if test='not( $person/about-owner/text()="yes" )'>
          <address>The profile is maintained by <a 
          href='mailto:{$user-login}'><xsl:value-of select='$user-name/text()'
          /></a></address>
        </xsl:if>

        <p>Permanent link: <a href='{$response-data/permalink}'
        ><xsl:value-of select='$response-data/permalink/text()'
        /></a></p>
    
      </xsl:with-param>
    </xsl:call-template> <!-- /page -->
  </xsl:template>






</xsl:stylesheet>

