<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

  <xsl:import href='../general/pages.xsl'/>
 
 <xsl:template match='/data'>
   <xsl:choose>

       <!-- shouldn't this instead use "success" ? -->

     <xsl:when test='$any-errors'>

   <xsl:call-template name='page'>
    <xsl:with-param name='title'>registration confirmation</xsl:with-param>
    <xsl:with-param name='body-title'>Confirmation problem</xsl:with-param>

    <xsl:with-param name='content' xml:space='preserve'>

      <p>Please check the URL in the email message.  Sometimes this is
      OK and you shouldn't worry: just try to log in.</p>

      <p>If it fails and you can't login, please let us know.</p>

    </xsl:with-param>
   </xsl:call-template>

     </xsl:when>
     <xsl:otherwise>

       <xsl:variable name='profile' select='$response-data/saved-profiles/list-item[@pos="0"]'/>

   <xsl:call-template name='page'>
    <xsl:with-param name='title'>New user registration confirmed</xsl:with-param>
    <xsl:with-param name='content' xml:space='preserve'>

     <h1>Confirmed succesfully</h1>

     <h2><xsl:value-of select='$user-name'/>,</h2>

     <p>Your account is activated and your profile is now available at:</p>

     <p><a href='{$profile/link}'><xsl:value-of select='$profile/link'/></a></p>

     <p>Whenever you need to update your profile, you can login into system.</p>

     <!-- 
     <xsl:if test='$response-data/saved-profiles/list-item'>
       <p>
       <xsl:for-each select='$response-data/saved-profiles/list-item'>
         <a href='{link/text()}'><xsl:value-of select='name'/></a>
       </xsl:for-each>
     </p>
     </xsl:if>
     -->

    </xsl:with-param>
   </xsl:call-template>

     </xsl:otherwise>
   </xsl:choose>
     

  </xsl:template>
</xsl:stylesheet>
