<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='../general/pages.xsl'/>
  
  
  <xsl:template match='/data'>
    <xsl:call-template name='page'>
      <xsl:with-param name='title'>You're almost done</xsl:with-param>
      <xsl:with-param name='content' xml:space='preserve'>
        
        <h1>Confirm</h1>

        <xsl:call-template name='show-status'/>

        <xsl:if test=' not( $any-errors )'>

          <h2>A confirmation mail was sent to you</h2>
          
          <p>The address it was sent to is: <xsl:value-of select='$user-login'/></p>
        
          <p>Please check your mailbox and follow instructions in the
          message you get.  Let us know if you do not get the message.</p>
          
        <!-- 
             <p><a href='{$response-data/confirmation-url}'>confirm now!</a></p>
        -->

        </xsl:if>
        
        <p>Your registration will be complete, when you confirm it.</p>
          

      </xsl:with-param>
    </xsl:call-template>
  </xsl:template>
</xsl:stylesheet>
