<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">

  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>
 
 <xsl:template match='/data'>
   <xsl:call-template name='page'>
     <xsl:with-param name='title'>additional info: name variations and interests</xsl:with-param>
     <xsl:with-param name='content' xml:space='preserve'>

       <h1>Registration: step 2</h1>


       <xsl:call-template name='show-status'/>


       <form xsl:use-attribute-sets='form'>
         <xsl:call-template name='fieldset'><xsl:with-param name='content' xmlns='http://x'>
         
         <xsl:if test='$response-data/ask-latin-name'>

           <h2>Your name in Latin letters</h2>

           <p><label class='form-field'>For the international users to
           be able to read and write your name; required:<br/>
           <input name='name-latin' size='50'/>
           </label></p>

         </xsl:if>

     <h2>Variations of your name</h2>
     <p>
      <label class='form-field'>Different ways your name may appear in
      documents' metadata; one variation per line:<br />
       <textarea class='edit' name='name-variations' cols='50' rows='10'/>
      </label>
     </p>

     <h2>Areas of academic interest</h2>
     <p>
      <label class='form-field'>Please list your areas of interest in academics.
      Type keywords or phrases, one per line.<br/>

       <textarea class='edit' name='sci-fields' cols='50' rows='6'/>
      </label>
     </p>
    </xsl:with-param></xsl:call-template>

   <input type='submit' value='continue'/>
   </form>
     </xsl:with-param>
   </xsl:call-template>
 </xsl:template>

</xsl:stylesheet>