<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0">
  
  <xsl:import href='../general/pages.xsl'/>
  <xsl:import href='../general/forms.xsl'/>
  
  
  <!--   p a g e   -->

  <xsl:template match='/data'>


    <xsl:variable name='content' xml:space='preserve'>

      <h1>Submit new institution</h1>

      <xsl:call-template name='show-status'><xsl:with-param name='fields-spec-uri' 
      select='"../fields-institution.xml"'/></xsl:call-template>
          

        <form xsl:use-attribute-sets='form'>

        <h2>the institution</h2>

          <xsl:call-template name='fieldset'><xsl:with-param name='content' xmlns='http://x'>

              <p>
        <label>Name in original language, required:<br />
         <input name='name' size='50'/><br/>
        </label>
        
        <label>Name in English, optional:<br />
         <input name='name-english' size='50'/><br/>
        </label>

        <label>Geographical location (Country, Town), required:<br />
         <input name='location' size='50'/><br/>
        </label>

        <label>Website address, required:<br />
         <input name='homepage' size='50'/><br/>
        </label>

        <label>Email address, optional:<br />
         <input name='email' size='50'/><br/>
        </label>

        <xsl:if test='$form-values/handle'>

          <label>Postal address
            <br/>
            <input name='postal' size='50'/><br/>
          </label>
        
          <label>Phone
            <br/>
            <input name='phone' size='50'/><br/>
          </label>
          
          <label>Fax
            <br/>
            <input name='fax' size='50'/><br/>
          </label>
          
          <input type='hidden' name='handle'/>
          
        </xsl:if>

</p>

        <!-- XXX: is this normal? -->

        <p><label>
        <input type='checkbox' name='add-to-profile' id='add-to-profile' checked='yes' />
          add this institution to my affiliations profile
        </label></p>

        <p><label>
        Anything you would like to add to the above, optional:<br />
        <textarea name='note' cols='50' rows='4'/>
      </label><br/>
        
        <input type='submit' name='action' value='submit'/>
      </p>

     </xsl:with-param></xsl:call-template>
   </form> 
  </xsl:variable>




      <xsl:choose>
        <xsl:when test='$user-login and $session-type="user"'>

          <xsl:call-template name='registered-user-page'>
            <xsl:with-param name='title'>submit a new institution</xsl:with-param>
            <xsl:with-param name='content' select='$content'/>
          </xsl:call-template> <!-- /registered-user-page -->

        </xsl:when>
        <xsl:otherwise>
          
          <xsl:call-template name='page'>
            <xsl:with-param name='title'>submit a new institution</xsl:with-param>
            <xsl:with-param name='content'>
              <!--              <h2> -->

              <xsl:copy-of select='$content'/>
            </xsl:with-param>
          </xsl:call-template> <!-- /page -->

        </xsl:otherwise>
      </xsl:choose>


 </xsl:template>

</xsl:stylesheet>