<!DOCTYPE xsl:stylesheet [

<!ENTITY nbsp   "&#160;"> <!-- no-break space = non-breaking space,
                               U+00A0 ISOnum -->

]>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  exclude-result-prefixes='exsl xml x'
  xmlns:x='http://x'
  version="1.0">
 

  <xsl:import href='global.xsl'/>
  <!-- global variables are there... -->



  <xsl:output
    method='xml'
    doctype-public='-//W3C//DTD XHTML 1.0 Strict//EN'
    doctype-system='http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
    omit-xml-declaration='yes'
    encoding='utf-8'/>




 <!-- GLOBAL ACIS PAGE TEMPLATE -->


 <xsl:template name='page'>
   <xsl:param name='content'/>
   <xsl:param name='title'/>
   <xsl:param name='body-title'/>
   <xsl:param name='show-errors'/>
   <xsl:param name='headers'   />

<html xml:space='preserve'>
 <head>
  <title><xsl:value-of select='$site-name'/>: <xsl:value-of select='$title'/></title>
  <xsl:choose><xsl:when 
  test='$css-url'><link rel="stylesheet" href="{$css-url}" type="text/css"/></xsl:when
  ><xsl:otherwise><style type='text/css'>
body { margin: 40px 40px 40px 0px; background: #eee; padding-left: 40px; } 
/*     ^^^ dirty IE/Win hack, because it doesn't understand body margins well */

form { background: #f4f4f4; padding: 2em; padding-top: 0.6em; padding-bottom: 0.6em; }
form.narrow { padding-top: 4px; padding-bottom: 4px; }
form p { padding: 0; }
form.narrow p { margin-top: 4px; margin-bottom: 4px; }
a:link, a:visited { font-weight: bold; }
.edit { background: #fff; }
.highlight { background: #ffd; }

.errors { border-left: 9px solid #c66; border-right: 9px solid #c66; 
 background: #fee;
 padding: 14px;
 padding-top: 2px; padding-bottom: 2px;
}
.errors p { margin-top: 4px; margin-bottom: 4px; padding: 0px; }
.errors ul,
.errors ul li { margin-top: 4px; margin-bottom: 4px; }


.msg { border-left: 9px solid #6c6; border-right: 9px solid #6c6; 
 background: #efe;
 padding: 14px;
 padding-top: 2px; padding-bottom: 2px;
}
.msg p { margin-top: 4px; margin-bottom: 4px; padding: 0px; }


.institutions form { padding-left: 10px; } 
.institutions li.institution { margin-bottom: 1.2em; }

div.photo { margin-left: 2em; margin-bottom: 2em; float: right; }
img.photo { margin: 5px; padding: 1px; border: 1px solid black; }

</style></xsl:otherwise></xsl:choose>
  <xsl:copy-of select='$headers'/>
 </head>
 <body>


   <div class='header'>
     <p>
       <a class='site-title' href='{$base-url}'><xsl:value-of select='$site-name-long'/></a>
     <!-- | <a href='-{$help-url}-' title='now useless'>Help</a> 
          XXX help link -->
     </p>
   </div>
  
   <div class='content'>

   <xsl:if test='$body-title' xml:space='default'>
     <h1><xsl:value-of select='$body-title'/></h1>
   </xsl:if>

   <xsl:if test='$show-errors' xml:space='default'>
       <xsl:call-template name='show-errors'/>
   </xsl:if>

     <xsl:copy-of select='$content'/>

   </div>

   <div class='footer'>
     <p>
       <xsl:if test='$problem-report-url'>
         <a href='{$problem-report-url}'>Report problems</a> |
       </xsl:if>

       <a href='mailto:{$admin-email}'>Administrator</a>

<!--
       <xsl:call-template name='email'><xsl:with-param name='address' select='$admin-email'/><xsl:with-param name='label' select='"Administrator"'/></xsl:call-template> 
-->

 |
       <a href='{$base-url}'>Home</a>

       <!-- XXX help link 
            | 
       <a href='{$base-url}/manual'>Help</a> -->
     </p>
   </div>

   <div class='after-footer'>

     <xsl:if test='$debug-mode="on"'>
       <xsl:comment> debuggings go here </xsl:comment>
     </xsl:if>

  </div>


 </body>
</html>
 </xsl:template>
 






 <!-- PAGE TEMPLATE FOR REGISTERED USER SCREENS -->


 
 <xsl:template name='registered-user-page-header'>
   <div>
   <div id='header'>
     <p class='left'><span class="welcome">Welcome <span class='name'>
     <xsl:value-of select='$user-name'/>
   </span>.</span>

<xsl:text>
</xsl:text>

You edit
<xsl:choose>
<xsl:when test='$record-about-owner'>your personal record</xsl:when>
<xsl:otherwise>the record about <span class='name'><xsl:value-of select='$record-name'/></span>
</xsl:otherwise>
</xsl:choose>.</p>

<xsl:text>
</xsl:text>

   <p class='util'>
     <a href='{$base-url}/welcome!{$session-id}'>Menu</a>,
     <a href='{$base-url}/profile-overview!{$session-id}'>profile overview</a>,
     <a href='{$base-url}/off!{$session-id}'>log off</a>.
   </p>

  </div>

  <div class='after-header-space'><span></span></div>

</div>
 </xsl:template>
 
 <xsl:template name='registered-user-page-footer'>
 </xsl:template>
 


 <xsl:template name='registered-user-page'>
   <xsl:param name='content'   />
   <xsl:param name='headers'   />
   <xsl:param name='title'     />

   <xsl:call-template name='page'>

     <xsl:with-param name='title'   select='$title'    />
     <xsl:with-param name='headers' select='$headers'  />
     <xsl:with-param name='content' xml:space='preserve'>

       <xsl:call-template name='registered-user-page-header'/>

  <div id='main'>

    <xsl:copy-of select='$content'/>


   <!--  XXX this only looks good for person records  -->
   <div id='user-menu'>
     <h1><a href='{$menu-url}'>Menu</a>:</h1>  

    <xsl:call-template name='user-menu'/>

   </div>


  </div>

  <xsl:call-template name='registered-user-page-footer'/>

     </xsl:with-param>

   </xsl:call-template>

 </xsl:template>
 



  <!--  MAIN  MENU   -->


  <xsl:template name='user-menu'>  
 <ul class='menu'>
   <li><a href='{$base-url}/personal-data!{$session-id}'
   >name and contact details</a></li>

   <li><a href='{$base-url}/affiliation!{$session-id}'
   >affiliation and employment profile</a></li>

   <li><a href='{$base-url}/sci-fields!{$session-id}'
   >scientific fields profile</a></li>
   
   <li><a href='{$base-url}/photo!{$session-id}'
   >upload photo</a></li>

   <li><a href='{$base-url}/contributions!{$session-id}'
   >academic contributions profile</a> (not ready yet)<!-- XXX --></li>

<!--
   <li><a href='{$base-url}/logoff!{$session-id}'
   >leave and save changes</a></li>
   
   <li><a href='{$base-url}/outside-profile!{$session-id}'
   >current state of the profile</a></li>
-->

 </ul>

 </xsl:template>



 <!-- outdated errors template -->

 <xsl:template name='display-human-readable-errors'>

   <p>This page uses outdated <code
   >display-human-readable-errors</code> template.  Please use <code
   >show-errors</code> instead.</p>
 
 </xsl:template>




  <!--  SHOW  ERRORS  template  -->


  <xsl:template name='show-errors'>

    <xsl:param name='fields-spec-uri'/>

    <xsl:variable name='errors-table' select='document( "../errors.xml" )' />
    <xsl:variable name='fields-table' select='document( $fields-spec-uri )' />

    <div class='errors'>
      <xsl:if test='$error'>
        <xsl:variable name='errtext' select='$errors-table//error[@id=$error]/text()'/>

        <p>Error: 

        <xsl:if test='$errtext'>
          <xsl:value-of select='$errtext'/>
        </xsl:if>
        <xsl:if test='not($errtext)'>
          undescribed, code: <xsl:value-of select='$error'/>
        </xsl:if>
        </p>
      </xsl:if>

      <xsl:if test='/data/errors/list-item'>
        
        <p>Errors: (this should not be! XXX)</p>

        <ul>
        <xsl:for-each select='/data/errors/list-item'>

          <xsl:variable name='err' select='text()'/>
          <xsl:variable name='errtext' select='$errors-table//error[@id=$err]/text()'/>

          <li>
        <xsl:if test='$errtext'>
          <xsl:value-of select='$errtext'/>
        </xsl:if>
        <xsl:if test='not($errtext)'>
          undescribed, code: <xsl:value-of select='$err'/>
        </xsl:if>
          </li>
        </xsl:for-each>
      </ul>
    </xsl:if>

      <xsl:if test='$form-errors/required-absent/list-item'>
        <p>These fields are required:</p>
        <ul>
          <xsl:for-each select='$form-errors/required-absent/list-item'>
            <xsl:variable name='field' select='text()'/>
            <xsl:variable name='desc' select='$fields-table//field[@name=$field]/desc/text()'/>

            <li><xsl:value-of select='$desc'/></li>

          </xsl:for-each>
        </ul>
      </xsl:if>

      <xsl:if test='$form-errors/invalid-value/list-item'>
        <p class='error'>The values you entered into these fields are invalid:</p>
        <ul>
          <xsl:for-each select='$form-errors/invalid-value/list-item'>
            <xsl:variable name='field' select='text()'/>
            <xsl:variable name='desc' select='$fields-table//field[@name=$field]/desc/text()'/>

            <li><xsl:value-of select='$desc'/></li>

          </xsl:for-each>
        </ul>

      </xsl:if>
    </div>
  </xsl:template>



  <!--  SHOW  STATUS  -->

  <xsl:template name='show-status'>

    <xsl:param name='fields-spec-uri' select='"../fields.xml"'/>

    
    <div class='status'>

      <xsl:if test='$any-errors'>
        <xsl:call-template name='show-errors'>
          <xsl:with-param name='fields-spec-uri' select='$fields-spec-uri'/>
        </xsl:call-template>
      </xsl:if>

      <xsl:if test='$message'>
        <xsl:variable name='msg-table' select='document("../messages.xml")'/>

        <div class='msg'>
          <xsl:choose>
            <xsl:when test='$msg-table//message[@id=$message]'>
              <p><xsl:value-of select='$msg-table//message[@id=$message]/text()'/></p>
            </xsl:when>
            <xsl:otherwise>
              <p>Undescribed message, code: <xsl:value-of select='$message'/></p>
            </xsl:otherwise>
          </xsl:choose>
        </div>

      </xsl:if>
    </div>
  
  </xsl:template>



 
 <xsl:attribute-set name='form'>
  <xsl:attribute name='action'><xsl:value-of select='$form-action'/></xsl:attribute>
  <xsl:attribute name='method'>post</xsl:attribute>
  <xsl:attribute name='enctype'>application/x-www-form-urlencoded</xsl:attribute>
  <xsl:attribute name='accept-charset'>utf-8</xsl:attribute>
 </xsl:attribute-set>



</xsl:stylesheet>
