<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:exsl="http://exslt.org/common"
  exclude-result-prefixes='exsl'
  version="1.0">

  
  <xsl:variable name='fields-table' select='document("../fields.xml")'/>
    

  <!-- is this useful -->

  <xsl:template name='field-value' xml:space='preserve'
    ><xsl:param name='name' 
    /><xsl:variable name='text' select='$fields-table/fields/field[@name=$name]/desc/text()'
    /> <span class='field-name'><xsl:value-of select='$text'/>: </span><br/>
 <span class='field-value'><xsl:value-of select='$form-values/*[@key=$name]/text()'/></span><br/>
  </xsl:template>
  

  <xsl:template name='input' xml:space='preserve'>
    <xsl:param name='name'
      /><xsl:variable name='text' select='$fields-table/fields/field[@name=$name]/desc/text()'
      /><label class='field-name' for='{$name}'><xsl:value-of select='$text'/>: 
  </label><br/>
  <input class='edit' name='{$name}' id='{$name}' value='{$form-value/*[@key=$name]/text()}'
    ><xsl:if test='contains($form-errors//list-item/text(), $name)'><xsl:attribute name='class'>edit-highlight</xsl:attribute></xsl:if
  ></input><br/>
</xsl:template>


 <!--  fieldset  -->

 <xsl:template name='fieldset'>
   <xsl:param name='content'/>

   <xsl:apply-templates mode='fs' select='exsl:node-set($content)' />
 </xsl:template>

 <!-- XXX: http://x namespace is so fucking descriptive -->


 <xsl:template match='x:form' mode='fs' xmlns:x='http://x'>
   <form xsl:use-attribute-set='form'>
     <xsl:copy-of select='@*'/>
     <xsl:apply-templates mode='fs'/>
   </form>
 </xsl:template>

 <xsl:template match='x:input[@type="text" or @type="password" or not(@type)]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='not( @class )'>
       <xsl:attribute name='class'>edit</xsl:attribute>
     </xsl:if>
     <xsl:if test='not( @type )'>
       <xsl:attribute name='type'>text</xsl:attribute>
     </xsl:if>
     <xsl:if test='not (@type="password")'>
       <xsl:attribute name='value'>
         <xsl:value-of select='$form-values/*[@key=$name]/text()'/>
       </xsl:attribute>
     </xsl:if>
     <xsl:if test='$form-errors//list-item=$name'>
       <xsl:attribute name='class'>edit highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>


 <!-- checkbox -->

 <xsl:template match='x:input[@type="checkbox"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='$form-values/*[@key=$name]/text()'>
      <xsl:attribute name='checked' value='1'/>
     </xsl:if>
     <xsl:attribute name='value'>true</xsl:attribute>
     <xsl:attribute name='class'>checkbox</xsl:attribute>
     <xsl:if test='contains($form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>checkbox highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>

 
 <!-- radio -->
 <xsl:template match='x:input[@type="radio"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@type|@id|@name|@value'/>

     <xsl:choose>

       <xsl:when test='not( $form-values/*[@key=$name] )'>

         <xsl:if test='@checked'>
           <xsl:attribute name='checked' value='1'/>
         </xsl:if>

       </xsl:when>

       <xsl:otherwise>

         <xsl:if test='$form-values/*[@key=$name]/text() = @value'>
           <xsl:attribute name='checked' value='1'/>
         </xsl:if>

       </xsl:otherwise>

     </xsl:choose>

     <xsl:attribute name='class'>radio</xsl:attribute>
     <xsl:if test='contains($form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>radio highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>


 <!-- hidden -->
 <xsl:template match='x:input[@type="hidden"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='not (@value)'>
       <xsl:attribute name='value'>
         <xsl:value-of select='$form-values/*[@key=$name]/text()'/>
       </xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>

 
 <!-- textarea -->
 <xsl:template match='x:textarea' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='textarea'>
     <xsl:copy-of select='@*'/>

     <!-- XXX class="edit" ? -->

     <xsl:if test='contains($form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>highlight</xsl:attribute>
     </xsl:if>
     <xsl:value-of select='$form-values/*[@key=$name]/text()'/>
   </xsl:element>
 </xsl:template>

 
 <!-- catch all -->

 <xsl:template match='x:*' mode='fs' xmlns:x='http://x'>
   <xsl:element name='{local-name()}'>
     <xsl:copy-of select="@*"/>
     <xsl:apply-templates mode='fs'/>
   </xsl:element>
 </xsl:template>


 <xsl:template match='*' mode='fs'>
   <xsl:copy>
     <xsl:copy-of select="@*"/>
     <xsl:apply-templates mode='fs'/>
   </xsl:copy>
 </xsl:template>



 <!--  end of fieldset mode -->


  
</xsl:stylesheet>

