# -*- Mode:perl -*-

use strict;

use ARDB::Test;

use ARDB;

$ARDB::DEBUG = 1;

my $ardb = ARDB -> new( "t/home" );

test $ardb;


my $sql = $ardb->{sql_object};

$sql -> prepare( 'select * from relations limit 10' );

my $res = $sql -> execute ();

test $res;

#use ARDB::Relation::Transaction;

for ( 1..10 ) {

  my $subj = $res->get('subject');
  my $obj  = $res->get('object');
  my $rel  = $res->get( 'relation' );
  my $src  = $res->get( 'source' );

  test $subj, "$subj -> $obj / $rel from $src";
  
  my $packed_relation = 
   ARDB::Relations::Transaction::pack_relation ($subj, $obj, $rel, $src);
   
  my ($subject, $object, $relation, $source) = 
   ARDB::Relations::Transaction::unpack_relation ($packed_relation);
  
  test $subject, "$subject -> $object / $relation from $source";
  
  test ($subj eq $subject,  "subject  unpacked ?");
  test ($obj  eq $object,   "object   unpacked ?");
  test ($rel  eq $relation, "relation unpacked ?");
  test ($src  eq $source,   "source   unpacked ?");
  
  $res->next;

}


