# -*- Mode: perl -*-

# $Id: table.t,v 1.2 2003/04/14 09:06:58 vano Exp $


use Test;
use strict;

BEGIN { plan tests => 7 ; }

use ARDB::Table;

my $table_name = 'test_authors_table';
my $table = new ARDB::Table ( $table_name );

ok( $table );

use Data::Dumper;

use sql_helper;
sql_helper -> set_log_filename ( 'sql_helper.log' );

###  create the object
my $sql = sql_helper -> new ( 'test', 'root', 'root' );

###  check the object
ok ( $sql );

$table -> add_field ("name", "VARCHAR(200) NOT NULL ");
$table -> add_field ("email", "VARCHAR(200) ");
$table -> add_field ("handle", "VARCHAR(200) NOT NULL PRIMARY KEY");

$table -> perform_create ( $sql );

{

  $sql -> prepare( "DESCRIBE $table_name");
  my $res = $sql -> execute ();
  ok ( $res );

}

$table -> perform_delete ( $sql );

{

  $sql -> prepare( "DESCRIBE $table_name");
  my $res = $sql -> execute ();
  ok ( not $res );

}


### another table 

$table_name = 'test_table_2';
$table = new ARDB::Table ( $table_name );

ok( $table );

$table -> add_field ("name", "VARCHAR(200) NOT NULL ");
$table -> add_field ("email", "VARCHAR(200) ");
$table -> add_field ("handle", "VARCHAR(200) NOT NULL PRIMARY KEY");

$table -> create_table_statement ( " index names ( name ), " );

$table -> perform_create ( $sql );

{
  $sql -> prepare( " DESCRIBE $table_name ");
  my $res = $sql -> execute ();
  ok ( $res );
}

$table -> perform_delete ( $sql );

{
  $sql -> prepare( " DESCRIBE $table_name ");
  my $res = $sql -> execute ();
  ok ( not $res );

}


  	
__END__

###  run a simple statement
$sql -> do ( 'DROP TABLE unnecessary' )
       || warn "failed to drop unnecessary table";
    ###  run a query 
    $sql -> prepare( "SELECT * FROM resources WHERE handle LIKE 'RePEc:per:%' " );
    my $r = $sql -> execute();
    ###  check the result
    while ( $r->{row} ) {  
        ###   ->{row} contains a reference to the field => value hash
        my $record = $r -> {row};
        my ( $title, $handle, $abstract );
        ###   -> get( 'field' ) retrieves the value:
        $title = $r -> get( 'title' );


        ###  ... and that is equivalent to:
        $title = $record -> {'title'};
        ###  ...and equivalent to (as you may guess):
        $title = $r -> {row} {title};
        ###  get other fields
        $abstract = $record -> {abstract};
        $handle   = $record -> {handle};
        ###  iterates to the next record in the query's return set
        $r-> next();
    }
    ###  a query with a parameter
    $sql -> prepare( 'select * from author_map where handle = ? ' );
    $r = $sql -> execute( $handle );
    ###  another one:
    $sql -> prepare( 'select * from person where lname = ? ' );
    ###  the param value is automatically quoted (!):
    $r = $sql -> execute( "O'Brien" );
