# -*- Mode:perl -*-

use strict;
use Carp::Assert;

use Data::Dumper;

use ARDB::Test;
use ARDB;

$ARDB::DEBUG = 1;

my $ardb = ARDB -> new( "t/home" );
test $ardb;

# print Dumper $ardb -> {'config'} -> {'relation_types'};

my $handle = 'RePEc:per:1112-01-01:GRISHA_TUTKEVICH';

use ARDB::Record::ReDIF;

use vars '%rels';

my $rec = $ardb -> get_unfolded_record ( $handle, 'brief' ) ;

test $rec;

test $rec->id;

test $rec->id eq $handle;

test $rec->type;

foreach (keys %$rec)
 {
  if (/^(.*)_rel$/)
   {
    print "### relation '$1' retrieved from '$handle' ###\n";
    test scalar @{ $rec -> {$_} }, "found ".scalar @{ $rec -> {$_} }." relations";
    print Dumper $rec -> {$_};
   }
 }

my $wrote = $rec->{'wrote_rel'};

test $wrote, 'testing relation wrote';

test ref $wrote eq 'ARRAY';
$wrote = $wrote -> [0];
test ref $wrote eq 'HASH';
test $wrote -> {title};
test $wrote -> {authors};
test $wrote -> {id};


my $affiliation = $rec->{'affiliated-with_rel'};

test $wrote, 'testing relation affiliated-with';

test ref $affiliation eq 'ARRAY';
$affiliation = $affiliation -> [0];
test ref $affiliation eq 'HASH';
test $affiliation -> {name};
test not scalar @{$affiliation -> {location}};
test $affiliation -> {id};

