# -*- Mode:perl -*-

use strict;
use Carp::Assert;

use ARDB::Test;

use ARDB;

$ARDB::DEBUG = 1;

my $ardb = ARDB -> new( "t/home" );
test $ardb;

my @handles;

my $sql = $ardb->{sql_object};

$sql -> prepare ('select handle,title,authors from documents limit 10');
my $res = $sql -> execute ();

assert( $res ); 

while ( $res->{row} ) {
  push @handles, $res->get('handle');
  $res->next;
}

die if not scalar @handles;


my $handle = shift @handles;
my $rec = $ardb -> get_unfolded_record ( $handle ) ;

test $rec;

test $rec->id;

test $rec->id eq $handle;

test $rec->type;


