# -*- Mode:perl -*-

use strict;

use ARDB::Test;

eval " use ARDB; ";

test not( $@ ), $@ ;

$ARDB::DEBUG = 1;

use ARDB;

my $ardb = ARDB -> new( "t/home" );

test $ardb;


use ARDB::Record::ReDIF;


my $file = $INC {'ReDIF/Record.pm'};

test $file, $file;

use ReDIF::Parser;

use Data::Dumper;

my $t;
my $dir = "t/data/ReDIF";

test ReDIF::Parser::open_dir_recursive( $dir );

while ( $t = ReDIF::Parser::get_next_template() ) {
  my $r = bless $t, 'ARDB::Record::ReDIF';
  print $r->id, "\n";
  test $ardb -> put_record( $r ), $r->id;
}



my $sql = $ardb->{sql_object};

$sql -> prepare( 'select handle,title,authors from documents limit 10' );

my $res = $sql -> execute ();

test $res;

for ( 1..10 ) {

  my $title   = $res->get('title');
  my $handle  = $res->get('handle');
  my $authors = $res->get( 'authors' );

  print "{$handle} T: $title, AU: $authors\n";
 
  test $handle, $handle;
  $res->next;

}



