package RePEc::Index::Collection::ACIS-UD;

use strict;
use vars qw( @ISA $POSITION );

use ACIS::Data::DumpXML::Parser;

use Digest::MD5;

@ISA = qw( RePEc::Index::Collection );
$POSITION = -1;

sub open_data_file
 {
  my $self = shift;
  my $file = shift;
  
  $self -> {'data'}  = ACIS::Data::DumpXML::Parser -> new -> parsefile ( $path );
  $self -> {'filename'} = $file;
 }

sub get_next_record
 {
  my $self = shift;
  
  my $data;
  my $checksum;
  
  if ($POSITION < 0)
   {
    $data  = $self -> {'data'} -> {'user'};
    
    $checksum = Digest::MD5::hex(Dumper $data);
    
    bless  $data, 'ACIS::UserData::User::Record';
   }
  else
   {
    $data  = $self -> {'data'} -> {'records'} -> [$POSITION];
    
    return 0
     unless defined $data;
    
    $checksum = Digest::MD5::hex(Dumper $data);
    $data -> {'LOGIN'} = $self -> {'data'} -> {'user'} -> {'login'};
    
    bless  $data, 'ACIS::UserData::Data::Record';
   }
  
  $data -> {'FILENAME'} = $self -> {'filename'}; 
  $POSITION++;
   
  return ($data -> id, $data, $data -> type, 0, $checksum); 
 }
 
sub check_id
 {
  return 1;
 }
 
1;