package ACIS::Web::Session;

use strict;

use ACIS::Common;

use ACIS::Data::DumpXML qw(dump_xml);

sub new
 {
  my $class = shift;
  my $paths  = shift;
  
  my $self =
   {
    'paths' => $paths,
   };
  
  bless  $self, $class;
  return $self;
 }

use Storable;

sub current_record
 {
  my $self = shift;
  
  if 
   (
    (defined $self -> {'user-data'}) and
    (defined $self -> {'user-data'} -> {'records'}) and
    (scalar  $self -> {'user-data'} -> {'records'})
   )
   {
    my $rec_no = $self -> {'current-record-number'} || 0 ;
    
    $self -> {'current-record-number'} = $rec_no;
    
    my $shared = $self -> {'paths'} -> {'shared'};
    my $static = $self -> {'paths'} -> {'static'};
    my $record = $self -> {'user-data'} -> {'records'} -> [$rec_no];
    my $sid = $record -> {'short-id'};
    
    unless (defined $self -> {'paths'} -> {'user-page'})
     {
      $self -> {'paths'} -> {'personal-path'}  = "$shared/$sid.",
      $self -> {'paths'} -> {'personal-url'}   = "$static/$sid.",
     }
     
    
    return $self -> {'user-data'} -> {'records'} -> [$rec_no];
   }
   
   
 }

sub save
 {
  my $self = shift;
  
  my $session = $self -> {'paths'} -> {'session'}; 
  
#  if ($ACIS::DEBUG and open (USERDATA, "> $session.xml"))
#   {
#    print USERDATA $self -> {'user-data'} -> dump_xml;
#    close USERDATA;
#   } 
  store $self, $session;
 }
 
sub load
 {
  my $self_ref = \$_[0]; shift;
  my $sid  = shift;
  
  my $paths = $$self_ref -> {'paths'};
  
  my $file_name = $paths -> {'session'};
  
  die "session '$file_name' not found"
   unless -f $file_name;
  
  debug 'session time difference: ' . (-M $file_name)*24*60*60 . ' seconds';
  
  unless ($ACIS::DEBUG)
   {
    die "saved session expires"
     if ((-M $file_name)*72 > 1);
   }
  
  my $loaded = retrieve ($file_name);
  
  $$self_ref = $loaded;
  $$self_ref -> {'paths'} = $paths;
  
 }

sub create
 {
  my $self = shift;
  my $sid  = shift;
  
  unless (defined $sid)
   {{
    debug "generate session-id";
    
    $sid = &generate_id;
    
    debug "generated '$sid' id";
    
    my $file_name = $self -> {'paths'} -> {'home'} . "/sessions/$sid.";
    
    if (-f $file_name)
     {
      debug "file found, try timestamp";
      
      next
       if ((-M $file_name)*72 > 1);
     }
    
    debug 'try create file';
    
    if (open SESSION, "> $file_name")
     {
      print SESSION 'new session';
      
      close SESSION;
      
      debug "session '$file_name' created";
      
      my $home = $self -> {'paths'} -> {'home'};
      
      $self -> {'paths'} -> {'session'} = "$home/sessions/$sid";
      $self -> {'paths'} -> {'unconfirmed'} = "$home/unconfirmed/$sid.xml";
      
      return $sid;
     }
    
    debug "cannot access file";
    
    next;
   }}
 }
 
1;
