package ACIS::Web::Screen;

use strict;

use Carp::Assert;

use Data::Dumper;


sub create
 {
  my $class = shift;
  my $id    = shift;
  
  my $self  = 
   {
    'id'           => $id,
    'processors'   => [],
    'presentation' =>
     {
      'type' => undef,
      'file' => undef,
     },
   };
   
   bless $self, $class;
   
   return $self;
 }

sub add_processor
 {
  my $self = shift;
  my @functions = @_;

  assert( @functions );
  
  push @{$self -> {'processors'}}, @functions;
 }

sub presentation_type
 {
  my $self = shift;
  my $received_type = shift;
  
  return $self -> {'presentation'} -> {'type'}
   unless defined $received_type;
  
  $self -> {'presentation'} -> {'type'}
   = $received_type;
 }
 
sub presentation_file
 {
  my $self = shift;
  my $received_filename = shift;
  
  return $self -> {'presentation'} -> {'file'}
   unless defined $received_filename;
  
  $self -> {'presentation'} -> {'file'}
   = $received_filename;
 } 
 
1;
