package ACIS::Web::Handler::User;

use strict;
use warnings;

use Data::Dumper;

use CGI::Untaint;

use ACIS::Common;
use ACIS::Data::DumpXML qw(dump_xml);

use ACIS::Web::Handler::Affiliations;
use ACIS::Web::Handler::Main;

sub login
 {
  debug "running login user screen";
  
  my $self = shift;
  
  $self -> redirect_to_screen ('welcome');
 }

sub welcome
 {
  debug "running initial user screen";
  
  my $self = shift;
  
  debug Dumper $self;
  
  $self -> variables -> {'form-data'} = $self -> session -> current_record;
  
#  my $current_user_data_i = ;
 }

#       $acis_web -> {entered-user-data}
#        ($acis_web -> {errors})  :
# [error-context, error-type]
#  ,       
# [screen-name/param-name, form-field/error-text]
#   mysql 
# [database, query-type/error-text]



sub personal_data
 {
  my $self = shift;
  
  debug "running personal data service screen";
  
  if (scalar $self -> request -> {CGI} -> param)
   {
    $self -> session -> current_record -> {'name-variations'} = 
     [split (/\s*[\n\r]+/, $self -> variables -> {'form-data'} -> {'name-variations'})];
    $self -> redirect_to_screen ('welcome');
   }
  else
   {
    $self -> variables -> {'form-data'} -> {'name-variations'} =
     join "\n", @{$self -> session -> current_record -> {'name-variations'}};
   }   
 }

sub upload_photo
 {
  debug "upload photo screen";
  
  my $self = shift;
  
  my $session = $self -> session;
  my $request = $self -> request;
  my $record  = $session -> current_record;
  my $query   = $request -> {'CGI'};
  
  $CGI::POST_MAX = 2097152;  #;-)
  
  my $url  = $self -> paths -> {'personal-url'};
  my $path = $self -> paths -> {'personal-path'};
  
  if ($record -> {'photo'} and -f $path . $record -> {'photo'})
   {
    $self -> variables -> {'photo'} = $url . $record -> {'photo'};
   } 
  
  return unless $query -> param ('photo');
  
  my $file = $query -> upload('photo');
  if (!$file && $query -> cgi_error)
   {
    push @{$self -> variables -> {'errors'}}, 'photo-cgi-error'; #$query -> cgi_error;
    return;
   }
  
  my ($extension) = (sprintf ("%s", $file) =~ /^.*\.(.*)$/);
  
  debug "try to save file into '$path$extension'";
  
  if (open PHOTO,"> $path$extension")
   {
    binmode PHOTO;
    my $buffer;
    while (read ($file, $buffer, 1024))
     {
      print PHOTO $buffer;
     }
    close PHOTO;
   }
  else
   {
    push @{$self -> variables -> {'errors'}}, 'photo-cannot-open-file';
    return;
   } 
  $session-> current_record -> {'photo'} = $extension;
  
  $self -> redirect_to_screen ('welcome');
 }


sub sci_fields
 {
  debug "running sci-fields service screen";
  
  my $self = shift;
  
  $self -> redirect_to_screen ('welcome')
   if (scalar $self -> request -> {CGI} -> param);
 }



sub affiliation
 {
  debug "running affiliation service screen";
  
  my $self   = shift;
  
  my $cgi    = $self -> request -> {CGI};
  
  if (scalar $cgi -> param)
   {
    my $action = $cgi -> param ('action');
    
    if ($action eq 'continue')
     {
#      ACIS::Web::Handler::Affiliations::commit ($self);
      $self -> redirect_to_screen ('welcome');
     }
    else
     {
      ACIS::Web::Handler::Affiliations::add    ($self)
       if $action eq 'add';
      ACIS::Web::Handler::Affiliations::remove ($self)
       if $action eq 'remove';
      ACIS::Web::Handler::Affiliations::search ($self)
       if $action eq 'search';
     }
   }
  else
   {
    # ACIS::Web::Handler::Affiliations::prepare ($self);
   }
  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
      and scalar @{$search -> {'items'}};
         
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;
   
 }

sub new_institution
 {
  my $self = shift;
  
  my $cgi  = $self -> request -> {CGI};
  my $configuration = $self -> config;
  my $session = $self -> session;
  
  return unless (scalar $cgi -> param);
  
  return unless ($cgi -> param('action') eq 'submit');

  ACIS::Web::Handler::Affiliations::add ($self)
   if ($cgi -> param ('add-institution'));
  
  &ACIS::Web::Handler::Main::send_mail ($self, 'email-new-institution.xsl');
  
  $self -> redirect_to_screen ('affiliation');
 }

sub unregister
 {
  my $self = shift;
  my $cgi  = $self -> request -> {CGI};
  
  return unless scalar $cgi -> param;
  
  if ($cgi -> param ('action'))
   {
    my $paths = $self -> paths;
    
    my $userdata = $paths -> {'user-data'};
    my $deleted_userdata = $paths -> {'deleted-user-data'};
    my $lock = $paths -> {'lock'};
    my $session = $paths -> {'session'};
    
    debug "rename user-data from '$userdata' to '$deleted_userdata'";
    
    rename $userdata, $deleted_userdata;
    
    debug "remove lock at '$lock' and remove session at '$session'";
    
    unlink $lock;
    unlink $session;
    
    &ACIS::Web::Handler::Main::send_mail ($self, 'email-delete-account.xsl');
    
    $self -> {'session'} = undef; 
    
    $self -> redirect ($self -> variables -> {'base-url'});
   }
   
 }

sub outside_profile
 {
  my $self = shift;
  
  my $screen = $self -> request -> {'screen'};
  my $screen_data = $self -> config -> screen ($screen);
  my $params = $screen_data -> {'variables'};

  my $cgi = $self -> {'request'} -> {'CGI'};
  foreach (@$params)
   {
    next unless defined $_ -> {'place'};
      
    my $data;
      
    my ($prefix, $place) = split ':', $_ -> {'place'};
    $prefix eq 'user' ?
     $data = $self -> session -> {'user-data'} -> {'user'}:
     $data = $self -> session -> current_record;
      
    $self -> variables -> {'form-data'} -> {$_ -> {'name'}} =
     ACIS::Web::Handler::Main::path_to_val ($data, $place);
   }
  
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
   $self -> variables -> {'affiliations'} = $affiliations
    if defined $affiliations and scalar @$affiliations;
 }


sub logoff
 {
  debug "processing logoff service screen";
  
  my $self = shift;
  
  #  user-data  session -> user-data
  
  my $content;
  
  if (open USERDATA, $self -> paths -> {'user-data'})
   {
    my $irs = $/;
    undef $/;
    
    $content = <USERDATA>;
    close USERDATA;
    
    $/ = $irs;
   }
  else
   {
    
   } 
  my $session_content = $self -> session -> {'user-data'} -> dump_xml;
  
  if ($session_content ne $content)
   {
    debug 'found some changes';
    
    my $record = $self -> session -> current_record;
    
    #  personal page
    
    my $pattern = 'user-outside-profile.xsl';
    my $path = $self -> paths -> {'personal-path'};
    
    my $config  = $self -> config;
    
    my $pattern_path = $self -> paths -> {'presenters'} . '/' . $pattern;
    
    if (open HTML, '> ' . $self -> paths -> {'personal-path'} . 'html')
     {
      print HTML ACIS::Web::launch_presenter
       ('xslt', dump_xml ($self -> variables), $pattern_path );
      
      close HTML;
     }
    
    &ACIS::Web::Handler::Affiliations::commit ($self);
    
    #   ,   .
    
    &ACIS::Web::Handler::Main::send_mail ($self, 'email-user-data-changes.xsl');
    
    #       user-data   .
    
    $self -> session -> {'user-data'} -> save ($self -> paths -> {'user-data'});
    
   }
  #  
  
  my $lock = $self -> paths -> {'lock'};
  my $session = $self -> paths -> {'session'};
    
  debug "remove lock at '$lock' and remove session at '$session'";
    
  unlink $lock;
  unlink $session;
  $self -> {'session'} = undef;
   
  # $self -> redirect ($self -> variables -> {'base-url'});
  
 }



###################################################################
############  obsolete functions, please ignore  ##################
###################################################################
 
sub old_affiliation
 {
  debug "running affiliation service screen";
  
  my $acis_web = shift;
  
  my $cgi = $acis_web -> request -> {'CGI'};
  my $screen = $acis_web -> {'request'} -> {'screen'};
  my @params = $cgi -> param;
  my $session = $acis_web -> session;
  my $record = $session -> current_record;
  
  #   affiliations  
  #    ,    user-data    ,
  #   unfold,     affiliation  mysql
  
  my $affiliations = $session -> {'affiliations'};
  my @affiliations = ();
  if (defined $record -> {'affiliations'})
   {
    @affiliations = @{$record -> {'affiliations'}};
   } 
    
  if (scalar @affiliations and (not defined $affiliations))
   {
    my $sql = $acis_web -> sql_object;
    
    my $sql_statement = join (' or ',
     map ("handle = '$_'", @affiliations));
    
    debug "sql statement: '$sql_statement'";
    
    $sql -> prepare ("select * from institutions where $sql_statement ");
    my $sql_res = $sql -> execute;
    
    unless (defined $sql_res)
     {
      $acis_web -> variables -> {'search-error'} = 'query error';
      log_error "select error text: " . $sql -> error;
      debug "select error";
     }
    
    my $search_results = $sql_res -> {rows};
       
    while ($search_results--)
     {  
      my $institution = $sql_res -> {row};
      
      push @$affiliations, $institution;
      $sql_res -> next;
     }
    $sql_res -> next;
   }
  
  $acis_web -> variables -> {'affiliations'} = $affiliations
   if ($affiliations and scalar @$affiliations);
   
  my $last_search = $session -> {'institution-search'};
  $acis_web -> variables -> {'search'} = $last_search
   if ($last_search and scalar keys %$last_search);
  
  return
   unless (scalar @params);
  
  my $redirect_screen = 'new-user/complete';
  
  debug "processing received user data";
  
  my $error = $acis_web -> process_input_parameters;
  
  unless ($error)
   {
    my $form_data = $acis_web -> variables -> {'form-data'};
    
    my $action = $form_data -> {'action'};
    
    if ($action eq 'search')
     {
      my $sql = $acis_web -> sql_object;
      
      my $what = '%' . $form_data -> {'search-what'} . '%';
      my $type = $form_data -> {'search-by'};
      
      return
       unless ($type =~ /location|name/);
      
      $sql -> prepare ("select * from institutions where $type like ? limit 51");
      my $sql_res = $sql -> execute ($what);
      
      unless (defined $sql_res)
       {
        push @{ $acis_web -> {errors} },
         ["database", 'select/'. $sql -> error];
        return;
       }
      
      my $search_results = $sql_res -> {rows};
      
      push @{ $acis_web -> {errors} },
       ["$screen/not-available", 'search/too-many-results']
        if $search_results > 50;
      
      my $search = {};
      $search -> {'results'} = $sql_res -> {rows};
      
      # name, email, postal, phone, fax, homepage, location
      
      while ($search_results--)
       {  
        my $search_item = $sql_res -> {row};
        push @{ $search -> {'items'} }, $search_item;
        
        $sql_res -> next;
       }

      $sql_res -> next;
      
      $acis_web -> variables -> {'search'} = $search;
      $session -> {'institution-search'} = $search;
      undef $redirect_screen;
     }
    elsif ($action eq 'continue')
     {
      #$session -> {'user-data'} -> {'affiliations'} =
      #$acis_web -> variables -> {'form-data'} -> {'affiliations'};
      $acis_web -> redirect_to_screen ( $redirect_screen );
      #delete $session -> {'institution-search'};
     }
    elsif ($action eq 'add')
     {
      my $handle = $acis_web -> variables -> {'form-data'} -> {'affiliation'};
      debug "try add '$handle' organization";
      
      my $search_items = $session -> {'institution-search'} -> {'items'};
      my $counter = 0;
      foreach my $institution (@$search_items)
       {
        $counter++;
        next unless ($institution -> {'handle'} eq $handle);
        push @{$session -> {'affiliations'}}, $institution;
        push @{$session -> {'user-data'} -> {'affiliations'}},
         $handle;
        debug "found '$handle' organization in search";
        last;
       }
      splice @$search_items, $counter-1, 1;
      
      $acis_web -> variables -> {'affiliations'} =
       $session -> {'affiliations'};
   
      $session -> {'institution-search'} -> {'results'} --;
      $acis_web -> variables -> {'search'} = $session -> {'institution-search'}
       if ($session -> {'institution-search'} -> {'results'});
      
      delete $acis_web -> variables -> {'form-data'} -> {'affiliation'};
     }
    elsif ($action eq 'remove')
     {
      my $handle = $acis_web -> variables -> {'form-data'} -> {'affiliation'};
      
      my $affiliations = $session -> {'affiliations'};
      
      my $counter = 0;
      
      #my $
      
      foreach my $institution (@$affiliations)
       {
        $counter++;
        next unless ($institution -> {handle} eq $handle);
        push @{$session -> {'institution-search'} -> {'items'}},
         $institution;
        last; 
       }
      splice @$affiliations, $counter-1, 1;
      splice @{$session -> {'user-data'} -> {'affiliations'}}, $counter-1, 1;
      
      $acis_web -> variables -> {'affiliations'} = $affiliations
       if ($affiliations and scalar @$affiliations);
   
      $session -> {'institution-search'} -> {'results'} ++;
      $acis_web -> variables -> {'search'} =
       $session -> {'institution-search'};
      
      delete $acis_web -> variables -> {'form-data'} -> {'affiliation'};
     } 
   }
 
  delete $acis_web -> {'user-data'} -> {'action'};
 }



sub old_personal_data
 {  
  my $self = shift;
  
  my $vars = $self -> variables;
  
  my $cgi = $self -> {'request'} -> {'CGI'};
  my @params = $cgi -> param;
  
  my $session = $self -> session;
  my $record = $session -> current_record;
  
  $vars -> {'form-data'} =
   $record;
  
  return unless scalar @params;
  
  debug "processing received user data";

  my $error = $self -> process_input_parameters;

  $record -> {'name-variations'} =
   [split /[\n\r]+/, $vars -> {'form-data'} -> {'name-variations'}];
   
  $vars -> {'form-data'} = $record;
  
  unless ($error)
   {
    $self -> redirect_to_screen ('welcome');
   }
 }


sub old_sci_fields
 {
  debug "running sci-fields service screen";
  
  my $self = shift;
  
  my $vars = $self -> variables;
  
  my $cgi = $self -> {'request'} -> {'CGI'};
  my @params = $cgi -> param;
  
  my $session = $self -> session;
  my $user_data = $session -> current_record;
  
  $vars -> {'form-data'} =
   $user_data;
  
  return unless scalar @params;
  
  debug "processing received user data";

  my $error = $self -> process_input_parameters;

  #$vars = $acis_web -> variables;
  
  $user_data -> {'interests'}
   = $vars -> {'form-data'} -> {'interests'};
  
 }

sub complete
 {
  debug "running new user registration complete service screen";
  
  my $acis_web = shift;
  
  my $session = $acis_web -> session;
  my $user_data = $session -> {'user-data'};
  
  my @temp_params = 
   (
    'action',
    'day',
    'month',
    'year',
    'search-by',
    'search-what'
   );
  
  foreach (@temp_params)
   {
    delete $user_data -> {$_};
   }
  
  my $dumped_data = dump_xml ($user_data);
  
  debug "data dumped, try generate confirmation-id";
  
  my $path = $acis_web -> {'home'} . '/unconfirmed/';
  my $confirmation_id = $session -> {'confirmation-id'};
  while ( (not $confirmation_id) and -f "$path$confirmation_id.xml")
   {
    $confirmation_id = &generate_id;
   }
  debug "confirmation-id: $confirmation_id";

  $session -> {'confirmation-id'} = $confirmation_id;

  open DUMPED, "> $path$confirmation_id.xml";
  print DUMPED $dumped_data;
  close DUMPED;
 
  my $configuration = $acis_web -> config;
  
  my $confirmation_url = $configuration->{'base-url'}
        . '/' . $acis_web -> request -> {'screen'} . '?' . $confirmation_id;

  my $email_from = $configuration -> {'email-from'}; #  (Acis@email)
  my $user_name  = $user_data -> {'full-name'};
  my $user_email = $user_data -> {'e-mail'};
  my $site_name  = $configuration -> {'site-name'};
  my $sendmail   = $configuration -> {'sendmail'};

  my $letter = launch_presenter
   (
    'xslt', 
qq[
<data>
 <email-from></email-from>
 <user-name></user-name>
 <user-email></user-email>
 <site-name></site-name>
 <url></url>
</data>
]
   );

  open MESSAGE, "> $path$confirmation_id.eml";
  print MESSAGE qq
[From: $email_from 
To: "$user_name" <$user_email>
Subject: confirm registration at $site_name

Hello,

Please open the URL shown below to confirm your registration.

$confirmation_url

Thank you.
];
  
  
 }


1;
