package ACIS::Web::Handler::NewUser;

use strict;
use warnings;

use Data::Dumper;

use CGI::Untaint;

use ACIS::Common;

use ACIS::Data::DumpXML qw( &dump_xml );


use ACIS::Web::Handler::Main;

use RePEc::ShortIDs::Client;

#      .  ,  
# ,  ,    .  ,  
# session, userdata,  redirect,    hardcoded.

sub initial
 {
  debug "running initial service screen";
  
  my $self = shift;
  my $cgi = $self -> {'request'} -> {'CGI'};
  
  unless (scalar $cgi -> param)
   {
    debug "no parameters found";
    my ($year, $month, $day) = (localtime)[5, 4, 3];
    
    $self -> variables -> {'form-data'} = 
     {
      'year'  => $year + 1900,
      'month' => $month + 1,
      'day'   => $day,
     };

    $self -> clear_process_queue;
    return;
    
   }

  debug 'found some parameters, processing received user data';

  if ($cgi -> param('pass') ne $cgi -> param('pass-confirm'))
   {
    $self -> clear_process_queue;
    return;
   }
    
  debug "creating session";
    
  my $sid;
  my $session = new ACIS::Web::Session ($self -> paths);
  eval {$sid = $session -> create};
   
  if ($@)
   {
    $self -> clear_process_queue;
    $self -> set_presenter ('service-temporary-unavailable');
    
    return;
   } 
  $session -> {'user-data'} = 
   {
    'user' => {},
    'records' => 
    [
     {
      'name' => {},
      'name-variations' => [],
     },
    ],
   };
  $session -> {'IP'} = $ENV{REMOTE_ADDR};
  $self -> {'session'} = $session;
  $self -> request -> {'session-id'} = $sid;
    
  $self -> redirect_to_screen ('new-user/additional');

 }


sub additional
 {
  my $self = shift;
  
  debug "running personal data service screen";
  
  debug Dumper $self -> session -> {'user-data'};
  
  if (scalar $self -> request -> {CGI} -> param)
   {
    $self -> session -> current_record -> {'name-variations'} = 
     [split (/\s*[\n\r]+/, $self -> variables -> {'form-data'} -> {'name-variations'})];
    $self -> redirect_to_screen ('new-user/affiliation');
   }
  else
   {
    $self -> variables -> {'form-data'} -> {'name-variations'} =
     join "\n", @{$self -> session -> current_record -> {'name-variations'}};
   }
  
 }

sub affiliation
 {
  debug "running affiliation service screen";
  
  my $self   = shift;
  
  my $cgi    = $self -> request -> {CGI};
  
  if (scalar $cgi -> param)
   {
    my $action = $cgi -> param ('action');
    
    if ($action eq 'continue')
     {
#      ACIS::Web::Handler::Affiliations::commit ($self);
      $self -> redirect_to_screen ('new-user/complete');
     }
    else
     {
      ACIS::Web::Handler::Affiliations::add    ($self)
       if $action eq 'add';
      ACIS::Web::Handler::Affiliations::remove ($self)
       if $action eq 'remove';
      ACIS::Web::Handler::Affiliations::search ($self)
       if $action eq 'search';
     }
   }
  else
   {
    # ACIS::Web::Handler::Affiliations::prepare ($self);
   }
  my $search = $self -> session -> {'search'};
  $self -> variables -> {'search'} = $search
   if defined $search and ref( $search->{items} ) 
      and scalar @{$search -> {'items'}};
   
  my $affiliations = $self -> session -> current_record -> {'affiliations'};
  $self -> variables -> {'affiliations'} = $affiliations
   if defined $affiliations and scalar @$affiliations;
   
 }

sub new_institution
 {
  my $self = shift;
  
  unless (scalar $self -> request -> {CGI} -> param)
   {
    $self -> clear_process_queue;
    return;
   }

  # place email code here
  
  $self -> redirect_to_screen ('new-user/affiliation');
 }
 
sub complete
 {
  debug "running new user registration complete service screen";
  
  my $acis_web = shift;
  my $session = $acis_web -> session;
  
  $session -> {'user-data'} -> {'user'} =
   {
    'login'    => $session -> current_record -> {'e-mail'},
    'name'     => $session -> current_record -> {'full-name'},
#    'password' => $session -> current_record -> {'password'},
   };

  debug Dumper $session -> {'user-data'};

  my $dumped_data = dump_xml ($session -> {'user-data'});
  
  debug "data dumped, try generate confirmation-id";
  
  my $path = $acis_web -> {'home'} . '/unconfirmed/';
  my $confirmation_id = $session -> {'confirmation-id'};
  
  unless (defined $confirmation_id)
   {
    $confirmation_id = generate_id;
  
    while (-f "$path$confirmation_id.xml")
     {
      $confirmation_id = &generate_id;
     }
   }  

  debug "confirmation-id: '$confirmation_id'";

  $session -> {'confirmation-id'} = $confirmation_id;

  open DUMPED, "> $path$confirmation_id.xml";
  print DUMPED $dumped_data;
  close DUMPED;
 
  my $configuration = $acis_web -> config;
  
  my $confirmation_url = $configuration->{'base-url'}
        . '/confirm!' . $confirmation_id;
  
  my $data =
   {
    'email-from' => $configuration -> {'email-from'},
    'user-name'  => $session -> current_record -> {'full-name'},
    'user-email' => $session -> current_record -> {'e-mail'},
    'site-name'  => $configuration -> {'site-name'},
    'url'        => $confirmation_url,
   };
  
  debug "you can apply registration, clicking a <a href='$confirmation_url'>following url</a>";
  
  &ACIS::Web::Handler::Main::send_mail ($acis_web, $data, 'email-confirmation.xsl');

 }

sub confirm
 {
  my $self = shift;
  
  debug "running new user confirmation screen";
  my $confirmation_id = $self -> request -> {'session-id'};
  
  debug "received '$confirmation_id', try open file " . $self -> paths -> {'unconfirmed'};
  
  return
   unless -f $self -> paths -> {'unconfirmed'};
  
  my $user_data = $self -> user_data
   ($self -> paths -> {'unconfirmed'});
  
  my $login     = $user_data -> {'user'} -> {'login'};

  use Carp::Assert;

  assert( $login );

  $user_data -> changed;
  
  my $record = $user_data -> {records} -> [0];
  
  # get short-id for a person 
  my $handle = $record -> {'handle'};
  my $name   = $record -> {'name'} -> {'last'};

  my $sid = 
   RePEc::ShortIDs::make_up_short_id_for_a_person
     ($handle, $name);

  unless (defined $sid)
   {
    critical "we try to receive short-id, but receiver is bad ;-) ";
   }
  
  $record -> {'short-id'} = $sid;
  
  debug Dumper $user_data;
  


  my $word_login = $login;
  $word_login =~ s/\W//g;

  assert( $word_login );
  
  my $fl = substr ($word_login, 0, 1);
  my $sl = substr ($word_login, 1, 1);
  
  force_dir ($self -> {'home'} . '/userdata', "$fl/$sl");
  
  $self -> {'paths'} -> {'user-data'} = $self -> {'home'} . "/userdata/$fl/$sl/$login.xml";
  
  $user_data -> save ($self -> paths -> {'user-data'});
  
  debug "saving user-data at " . $self -> paths -> {'user-data'};
  
  unlink $self -> paths -> {'unconfirmed'}
   unless $ACIS::DEBUG;
  
  debug "deleted unconfirmed user-data at " . $self -> paths -> {'unconfirmed'};
  
  
 }

###################################################################
############  obsolete functions, please ignore  ##################
###################################################################

sub old_affiliation
 {
  debug "running affiliation service screen";
  
  my $acis_web = shift;
  
  my $cgi = $acis_web -> {'request'} -> {'CGI'};
  my $screen = $acis_web -> {'request'} -> {'screen'};
  my @params = $cgi -> param;
  my $session = $acis_web -> session;
  
  $acis_web -> variables -> {'form-data'} = $session -> {'user-data'};
  
  my $affiliations = $session -> {'affiliations'};
  $acis_web -> variables -> {'affiliations'} = $affiliations
   if ($affiliations and scalar @$affiliations);
   
  my $last_search = $session -> {'institution-search'};
  $acis_web -> variables -> {'search'} = $last_search
   if ($last_search and scalar keys %$last_search);
  
  return
   unless (scalar @params);
  
  my $redirect_screen = 'new-user/complete';

  debug "processing received user data";

  my $error = $acis_web -> process_input_parameters;
  
  unless ($error)
   {
    my $form_data = $acis_web -> variables -> {'form-data'};
    
    my $action = $form_data -> {'action'};
    
    if ($action eq 'search')
     {
      my $sql = $acis_web -> sql_object;
      
      my $what = '%' . $form_data -> {'search-what'} . '%';
      my $type = $form_data -> {'search-by'};
      
      return
       unless ($type =~ /location|name/);
      
      $sql -> prepare ("select * from institutions where $type like ? limit 51");
      my $sql_res = $sql -> execute ($what);
      
      unless (defined $sql_res)
       {
        push @{ $acis_web -> {errors} },
         ["database", 'select/'. $sql -> error];
        return;
       }
      
      my $search_results = $sql_res -> {rows};
      
      push @{ $acis_web -> {errors} },
       ["$screen/not-available", 'search/too-many-results']
        if $search_results > 50;
      
      my $search = {};
      $search -> {'results'} = $sql_res -> {rows};
      
      # name, email, postal, phone, fax, homepage, location
      
      while ($search_results--)
       {  
        my $search_item = $sql_res -> {row};
        push @{ $search -> {'items'} }, $search_item;
        
        $sql_res -> next;
       }

      $sql_res -> next;
      
      $acis_web -> variables -> {'search'} = $search;
      $session -> {'institution-search'} = $search;
      undef $redirect_screen;
     }
    elsif ($action eq 'continue')
     {
      #$session -> {'user-data'} -> {'affiliations'} =
      #$acis_web -> variables -> {'form-data'} -> {'affiliations'};
      $acis_web -> redirect_to_screen ( $redirect_screen );
      #delete $session -> {'institution-search'};
     }
    elsif ($action eq 'add')
     {
      my $handle = $acis_web -> variables -> {'form-data'} -> {'affiliation'};
      debug "try add '$handle' organization";
      
      my $search_items = $session -> {'institution-search'} -> {'items'};
      my $counter = 0;
      foreach my $institution (@$search_items)
       {
        $counter++;
        next unless ($institution -> {'handle'} eq $handle);
        push @{$session -> {'affiliations'}}, $institution;
        push @{$session -> {'user-data'} -> {'affiliations'}},
         $handle;
        debug "found '$handle' organization in search";
        last;
       }
      splice @$search_items, $counter-1, 1;
      
      $acis_web -> variables -> {'affiliations'} =
       $session -> {'affiliations'};
   
      $session -> {'institution-search'} -> {'results'} --;
      $acis_web -> variables -> {'search'} = $session -> {'institution-search'}
       if ($session -> {'institution-search'} -> {'results'});
      
      delete $acis_web -> variables -> {'form-data'} -> {'affiliation'};
     }
    elsif ($action eq 'remove')
     {
      my $handle = $acis_web -> variables -> {'form-data'} -> {'affiliation'};
      
      my $affiliations = $session -> {'affiliations'};
      
      my $counter = 0;
      foreach my $institution (@$affiliations)
       {
        $counter++;
        next unless ($institution -> {handle} eq $handle);
        push @{$session -> {'institution-search'} -> {'items'}},
         $institution;
        last; 
       }
      splice @$affiliations, $counter-1, 1;
      splice @{$session -> {'user-data'} -> {'affiliations'}}, $counter-1, 1;
      
      $acis_web -> variables -> {'affiliations'} = $affiliations
       if ($affiliations and scalar @$affiliations);
   
      $session -> {'institution-search'} -> {'results'} ++;
      $acis_web -> variables -> {'search'} =
       $session -> {'institution-search'};
      
      delete $acis_web -> variables -> {'form-data'} -> {'affiliation'};
     } 
   }
 
  delete $acis_web -> {'user-data'} -> {'action'};
 }


sub old_additional
 {
  debug "running additional service screen";
  
  my $acis_web = shift;
  
  my $vars = $acis_web -> variables;
  my $cgi = $acis_web -> {'request'} -> {'CGI'};
  my @params = $cgi -> param;
  my $session = $acis_web -> session;
  my $user_data = $session -> {'user-data'};
  
  $vars -> {'form-data'} =
   $user_data;
  
  debug Dumper $session;
  
  unless (scalar @params)
   {
    return
     if $vars -> {'form-data'} -> {'name-variations'};
    
    debug "user should enter data";
    
    my $first_name   = $user_data -> {'first-name'};
    my $second_name  = $user_data -> {'second-name'};
    my $last_name    = $user_data -> {'last-name'};
    my $first_small  = substr $first_name, 0, 1;
    

    my $full_name = "$first_name $second_name $last_name";

    $full_name =~ s/\s+/ /g; 
    
    $vars -> {'form-data'} -> {'full-name'} = $full_name;

    my $handle_name = "$last_name $second_name $first_name";
    
    $handle_name = uc $handle_name;
    $handle_name =~ s/[^a-z]/_/gi;
    $handle_name =~ s/_+/_/g;
    
    
    my $year  = $user_data -> {'year'};
    my $month = $user_data -> {'month'};
    my $day   = $user_data -> {'day'};
    
    unless ($year or $month or $day)
     {
      ($day, $month, $year) = (localtime)[3,4,5];
      $year += 1900;
      $month ++;
      
     } 
    
    $month = "0$month"
     if $month < 10;
    $day = "0$day"
     if $day < 10;
                      
    my $handle = "RePEc:per:$year-$month-$day:$handle_name";
    
    $vars -> {'form-data'} -> {'name-variations'} = 
     [
      "$first_name $last_name",
      "$first_small. $last_name",
      "$last_name, $first_name",
      "$last_name, $first_small."
     ];
     
    if ($second_name) 
     {
      
      my $second_small = substr $second_name, 0, 1;
      push @{$vars -> {'form-data'} -> {'name-variations'}},
       (
        "$first_name $second_name $last_name",
        "$first_name $second_small. $last_name",
        "$first_small. $second_small. $last_name",
        "$last_name, $first_name $second_name",
        "$last_name, $first_name $second_small.",
        "$last_name, $first_small. $second_small."
       );
     }
    $user_data -> {'handle'} = $handle;
    $user_data -> {'name-variations'} =
     $vars -> {'form-data'} -> {'name-variations'};
    $user_data -> {'full-name'} =
     $vars -> {'form-data'} -> {'full-name'};
    
    return;
   }
  
  my $redirect_screen = 'new-user/affiliation';

  debug "processing received user data";

  my $error = $acis_web -> process_input_parameters;

  #$vars = $acis_web -> variables;
  
  $session -> {'user-data'} -> {'interests'}
   = $vars -> {'form-data'} -> {'interests'};
  $session -> {'user-data'} -> {'name-variations'} =
   [split /[\n\r]+/, $vars -> {'form-data'} -> {'name-variations'}];
  
  $acis_web -> redirect_to_screen ( $redirect_screen )
   unless ($error);
 }


sub old_initial
 {
  #     ,  e-mail,  1, 2, 3
  # , ,      -  puproses  
  # .
  
  debug "running initial service screen";
  
  my $acis_web = shift;
  
  my $cgi = $acis_web -> {'request'} -> {'CGI'};
  my @params = $cgi -> param;
  
  unless (scalar @params)
   {
    debug "no parameters found";
    my ($year, $month, $day) = (localtime)[5, 4, 3];
    
    $acis_web -> variables -> {'form-data'} = 
     {
      'year'  => $year + 1900,
      'month' => $month + 1,
      'day'   => $day,
     };
     
    return; 
   }
  
  debug "found some parameters";
  
  my $redirect_screen = 'new-user/additional';

  #  ,        ,
  #     ,    ,  ,
  #  ,      ,   
  #     e-mail  ,     
  #  user_data.

  debug "processing received user data";

  my $error = $acis_web -> process_input_parameters;

  unless ($error)
   {
    debug Dumper $acis_web -> variables -> {'form-error'};
    
    return
     unless ($acis_web -> variables -> {'form-data'} -> {'pass'} eq
             $acis_web -> variables -> {'form-data'} -> {'pass-confirm'});
    
    delete   $acis_web -> variables -> {'form-data'} -> {'pass-confirm'};
    
    debug "creating session";
    
    my $sid;
    my $session = new ACIS::Web::Session ($acis_web -> paths);
    eval {$sid = $session -> create};
   
    if ($@)
     {
      $acis_web -> clear_process_queue;
      $acis_web -> set_presenter ('service-temporary-unavailable');
   
      #########################
      # place error info here #
      #########################
    
      return;
     } 
    $session -> {'user-data'} = $acis_web -> variables -> {'form-data'};
    $session -> {'IP'} = $ENV{REMOTE_ADDR};
    $acis_web -> {'session'} = $session;
    $acis_web -> request -> {'session-id'} = $sid;
    
    $acis_web -> redirect_to_screen ( $redirect_screen );
   }
 }

#       $acis_web -> {entered-user-data}
#        ($acis_web -> {errors})  :
# [error-context, error-type]
#  ,       
# [screen-name/param-name, form-field/error-text]
#   mysql 
# [database, query-type/error-text]


1;
