package ACIS::Web::Handler::Main;

use strict;
use ACIS::Common;
use Data::Dumper;
use ACIS::Data::DumpXML qw(dump_xml);
use ACIS::Web;

sub send_mail
 {
  my $self = shift;
  my $pattern = shift;
  
  debug "sending email with template '$pattern'";
  
  my $data = 
   {
    'config'    => {},
    'paths'     => $self -> paths,
    'session'   => $self -> session,
    'user-data' => $self -> user_data,
    'variables' => $self -> variables,
   };
  
  foreach (keys %{$self -> config})
   {
    next if $_ eq 'screens';
    $data -> {'config'} -> {$_} = $self -> config -> {$_};
   }

  my $content = dump_xml ($data);
  debug $content;
  
  my $config  = $self -> config;
  
  my $pattern_path = $self -> paths -> {'presenters'} . '/' . $pattern;
  
  my $sendmail = $config -> {'sendmail'};
  
  unless (defined $sendmail and $sendmail)
   {
    debug "can't send e-mail message, because no sendmail path defined";
    return;
   }
  
  open MESSAGE, "> $sendmail";
  print MESSAGE  ACIS::Web::launch_presenter
   ('xslt', $content, $pattern_path );

  close MESSAGE;
 }

sub path_to_val
 {
  my $data  = shift;
  my $path  = shift;
  
  my @path  = split '/', $path;
  foreach (@path)
   {
    $data = $data -> {$_};
   }
  return $data;
 }

sub assign_path
 {
  my $data  = shift;
  my $path  = shift;
  my $value = shift;
  
  my $temp = $data;
  my @path = split '/', $path;
  my $last = pop @path;
  foreach (@path)
   {
    $temp = $temp -> {$_};
   }
  $temp -> {$last} = $value;
 }

sub process_input_parameters
 {
  my $self   = shift;
  
  my $required_absent;
  my $invalid_value;
  my $screen = $self -> request -> {'screen'};
  my $screen_data = $self -> config -> screen ($screen);
  my $params = $screen_data -> {'variables'};
  my $session_data = $self -> {'session'} -> {'user-data'};

  my $cgi = $self -> {'request'} -> {'CGI'};
  unless (scalar $cgi -> param)
   {
    foreach (@$params)
     {
      next unless defined $_ -> {'place'};
      
      my $data;
      
      my ($prefix, $place) = split ':', $_ -> {'place'};
      $prefix eq 'user' ?
       $data = $self -> session -> {'user-data'} -> {'user'}:
       $data = $self -> session -> current_record;
      
      $self -> variables -> {'form-data'} -> {$_ -> {'name'}} =
       path_to_val ($data, $place);
     }
    #$self -> clear_process_queue;
    debug Dumper $self -> variables -> {'form-data'};
    return;
   }

  my %cgi_vars = $cgi -> Vars;
  
  debug "loading CGI::Untaint";

  my $handler = new CGI::Untaint ({INCLUDE_PATH => 'ACIS/Web'}, \%cgi_vars );
  
  debug "processing input variables";
  
  foreach ( @$params )
   {
    my $type     = $_ -> {'type'};
    my $name     = $_ -> {'name'};
    my $required = $_ -> {'required'};
    
    next unless $type;
    
    my $value = undef;
    if (defined $cgi_vars{$name} and $cgi_vars{$name})
     {
      $value = $handler -> extract("-as_$type" => $name);
      $self -> variables -> {'form-data'} -> {$name} = $cgi -> param ($name);
     }
    
    if (defined $value and $value)
     { 
      $self -> variables -> {'verified'} -> {$name} = $value; 
     }
    else 
     {
      if ($handler -> {_ERR})
       {
        debug "not passed, because invalid value at $name with type='$type', $handler->{_ERR}";
        
        push @{$self -> variables -> {'form-errors'} -> {'invalid-values'}}, $name;
        $invalid_value = 'yes';
       }
      else
       {
        debug "undefined value at $name";
        
        if ($required)
         {
          $required_absent = 'yes';
          push @{$self -> variables -> {'form-errors'} -> {'required-absent'}}, $name;
         }
       } 
     }
   }

  if ($required_absent or $invalid_value)
   {
    $self -> clear_process_queue;
   }
  else 
   {
    foreach (@$params)
     {
      debug "apply parameter name = '" . $_ -> {'name'} . "', value = " . 
       $self -> variables -> {'verified'} -> {$_ -> {'name'}} . "'";
      
      next unless defined $_ -> {'place'};
      
      debug 'proceed...';
      
      my $data;
      
      my ($prefix, $place) = split ':', $_ -> {'place'};
      $prefix eq 'user' ?
       $data = $self -> session -> {'user-data'} -> {'user'}:
       $data = $self -> session -> current_record;
      
      assign_path
       ($data, $place, $self -> variables -> {'verified'} -> {$_ -> {'name'}});
     }
    delete $self -> variables -> {'verified'};
   }
  
  debug Dumper $self -> session;
  
 }


sub escape
 {
  my $string = shift;
  
  my @symbols = split //, $string;
  $string = '';
  foreach (@symbols)
   {
    $string .= ord;
   }
   
  return $string;
 }

sub check_input_parameters
 {
  my $self   = shift;
  
  my $required_absent;
  my $invalid_value;
  my $screen = $self -> request -> {'screen'};
  my $screen_data = $self -> config -> screen ($screen);
  my $params = $screen_data -> {'variables'};
  my $session_data = $self -> {'session'} -> {'user-data'};
  
  debug "loading CGI::Untaint";
  
  my $cgi = $self -> {'request'} -> {'CGI'};
  return unless scalar $cgi -> param;
  my %cgi_vars = $cgi -> Vars;
  
  my $handler = new CGI::Untaint ({INCLUDE_PATH => 'ACIS/Web'}, \%cgi_vars );
  
  debug "checking input parameters and values";
  
  my $errors;
  
  foreach (@$params)
   {
    my $type     = $_ -> {'type'};
    my $name     = $_ -> {'name'};
    my $required = $_ -> {'required'};
    
    next unless $type;
    
    my $value = undef;
    if (defined $cgi_vars{$name} and $cgi_vars{$name})
     {
      $value = $handler -> extract("-as_$type" => $name);
      $self -> variables -> {'form-data'} -> {$name} = $cgi -> param ($name);
     }
    
    unless (defined $value and $value)
     {
      if ($handler -> {_ERR})
       {
        debug "invalid value (" . $cgi->param($name) . ") of param $name with type='$type'";
        
        push @{$self -> variables -> {'form-errors'} -> {'invalid-values'}}, $name;
        $invalid_value = 'yes';
       }
      else
       {
        debug "undefined value of $name";
        
        if ($required)
         {
          $required_absent = 'yes';
          push @{$self -> variables -> {'form-errors'} -> {'required-absent'}}, $name;
         }
       }
     }
   }

  if ($required_absent or $invalid_value)
   {
    $self -> clear_process_queue;
   }
 }

sub prepare_user
 {
  my $self = shift;
  
  my $user_data = $self -> session -> current_record;
  
  my $first_name   = $user_data -> {'name'} -> {'first'};
  my $second_name  = $user_data -> {'name'} -> {'middle'};
  my $last_name    = $user_data -> {'name'} -> {'last'};
  my $first_small  = substr $first_name, 0, 1;
    
  my $full_name = "$first_name $second_name $last_name";

  $full_name =~ s/\s+/ /g; 
    
  $user_data -> {'full-name'} = $full_name;

  my $handle_name = "$last_name $second_name $first_name";
    
  $handle_name = uc $handle_name;
  $handle_name =~ s/[^a-z]/_/gi;
  $handle_name =~ s/_+/_/g;
  $handle_name =~ s/\s+/ /g; 
    
  my $year  = $user_data -> {'year'};
  my $month = $user_data -> {'month'};
  my $day   = $user_data -> {'day'};
    
  unless ($year or $month or $day)
   {
    ($day, $month, $year) = (localtime)[3,4,5];
    $year += 1900;
    $month ++;
   } 
    
  $month = "0$month"
   if $month < 10;
  $day = "0$day"
   if $day < 10;
  
  my $config = $self -> config;
  my $prefix = $config -> {'person-id-prefix'};
                      
  my $handle = "$prefix$year-$month-$day:$handle_name";
  
  $user_data -> {'type'} = 'person';
    
  $user_data -> {'name-variations'} = 
   [
    "$first_name $last_name",
    "$first_small. $last_name",
    "$last_name, $first_name",
    "$last_name, $first_small."
   ];
  
  if ($second_name) 
   {
    my $second_small = substr $second_name, 0, 1;
    push @{$user_data -> {'name-variations'}},
     (
      "$first_name $second_name $last_name",
      "$first_name $second_small. $last_name",
      "$first_small. $second_small. $last_name",
      "$last_name, $first_name $second_name",
      "$last_name, $first_name $second_small.",
      "$last_name, $first_small. $second_small."
     );
   }
  $user_data -> {'handle'} = $handle;
 }

1;

