package ACIS::Web::Handler::Authenticate;

use strict;
use warnings;

use sql_helper;

use Storable qw(store retrieve);

use ACIS::Common;

use CGI qw/standart/;
use CGI::Cookie;

use Carp::Assert;

sub authenticate
 {
  my $acis_web = shift;
  
  my $request  = $acis_web -> request;
  my $home     = $acis_web -> {'home'};
  
  my $IP       = $ENV{'REMOTE_ADDR'};
  my $sid      = $request -> {'session-id'};
  
  debug "retrieving data from ACIS::Web object";

  my $session = new ACIS::Web::Session ($acis_web -> paths);
  
  if (defined $sid)
   {
    debug "try continue session $sid";
    
    eval {$session -> load ($sid)};
    
    if ($@)
     {
      # session can't be found or expires, details in $@
      chomp $@;
      debug $@;
      push @{$acis_web -> variables -> {'errors'}}, 'login-session-access-denied';
     }
    else
     {
      if ($session -> {'IP'} eq $IP)
       {
        debug "previous session found, continued";
        
	use Data::Dumper;

	my $dump = Dumper( $session );
	
#	die "Session is <$dump>...";
	debug "session is like this <$dump>";

	assert( $session->{'user-data'} );
	assert( $session->{'user-data'}->{user} );

        my $login = $session -> {'user-data'} -> {'user'} -> {'login'};

        assert( $login );

        my $config = $acis_web -> config;
        my $shared = $config -> {'static-base-dir'};
  
        my $word_login = $login;
        $word_login =~ s/\W//g;
  
        my $fl = substr ($word_login, 0, 1);
        my $sl = substr ($word_login, 1, 1);
  
	assert( $fl );
	assert( $sl );

        my $paths =
         {
          'user-data'   => "$home/userdata/$fl/$sl/$login.xml",
          'lock'        => "$home/userdata/$fl/$sl/$login.lock",
          'deleted-user-data'
                        => "$home/deleted-userdata/$fl/$sl/$login.xml",
         };
  
        %{$acis_web -> {'paths'}} = (%{$acis_web -> {'paths'}}, %$paths);
        
        $acis_web -> {'session'} = $session;
        
        $acis_web -> variables -> {'user-name'} = $session -> {'user-data'} -> {'user'} -> {'name'};
        $acis_web -> variables -> {'record-name'} = $session -> current_record -> {'full-name'};
        
        return;
       }
     }
   }
  
  debug "eval received parameters";
  
  my $query = $request -> {'CGI'};
  my $query_params = scalar $query -> param;
  my $cookie_params =
   $query -> cookie ('login') and $query -> cookie ('pass');
  
  unless ($query_params or $cookie_params)
   {
    $acis_web -> clear_process_queue;
    $acis_web -> set_presenter ('index');
    return;
   }
  
  debug "try authorize user";
  
  my $user_data = authorize ($acis_web);
  
  unless (defined $user_data)
   {
    debug "authorization failed, generating exception";
    
    $acis_web -> clear_process_queue;
    $acis_web -> set_presenter ('index');
    
    push @{$acis_web -> variables -> {'errors'}}, 'login-authorization-failed';
    
    #   ,        
    #       . ,     ,
    #  -   ,     
    # zx-spectrum.

    return;
   }
  
  my $login = $user_data -> {'user'} -> {'login'};
  my $pass  = $user_data -> {'user'} -> {'password'};
  
  debug "user '$login' authorized, creating session";
  
  $sid = undef;
  $sid = $session -> create;
   
  unless (defined $sid and $sid)
   {
    $acis_web -> clear_process_queue;
    $acis_web -> set_presenter ('index');

    # someone strange
    
    push @{$acis_web -> variables -> {'errors'}}, 'login-someone-strange';
    
    return;
   } 
  
  debug "locking user-data"; 
  
  my $lock = $acis_web -> paths -> {'lock'};
  if (open LOCK, "> $lock")
   {
    print LOCK $acis_web -> paths -> {'session'};
    close LOCK;
   }
  
  my $auto_login = $request -> {'CGI'} -> param ('auto-login');
  
  if ($auto_login)
   {
    print "Set-Cookie: login=$login; path=/\n";
    print "Set-Cookie: pass=$pass; path=/\n";
     
    debug "cookie set";
   } 
           
  $session -> {'IP'} = $IP;
  $session -> {'login'} = $login;
  $acis_web -> {'session'} = $session;
  $acis_web -> request -> {'session-id'} = $sid;
  $session -> {'user-data'} = $user_data;
  
  $acis_web -> clear_process_queue;
  $acis_web -> redirect_to_screen ('welcome'); #$acis_web -> request -> {'screen'});
 } 

sub authorize
 {
  my $acis_web = shift;

  my $home     = $acis_web -> {'home'};
  my $request  = $acis_web -> request;
  
  my $login    = $request -> {'CGI'} -> param ('login');
  my $pass     = $request -> {'CGI'} -> param ('pass');

  unless ($login)
   {
    debug "query: login not found, try from cookie";
    
    $login = $request -> {'CGI'} -> cookie ('login');
    $pass  = $request -> {'CGI'} -> cookie ('pass');
    
    unless ($login)
     {
      push @{$acis_web -> variables -> {'errors'}}, 'login-undefined-credentials';
      return undef;
     }
   }
  
  debug "login field defined ($login)";
     
  unless ($pass)
   {
    push @{$acis_web -> variables -> {'errors'}}, 'login-undefined-credentials';
    return undef;
   }
  
  debug "pass field defined ($pass)";

  my $config  = $acis_web -> config;
  my $shared = $config -> {'static-base-dir'};
  
  my $word_login = $login;
  $word_login =~ s/\W//g;
  
  my $fl = substr ($word_login, 0, 1);
  my $sl = substr ($word_login, 1, 1);
  
  my $paths =
   {
    'user-data'   => "$home/userdata/$fl/$sl/$login.xml",
    'lock'        => "$home/userdata/$fl/$sl/$login.lock",
    'deleted-user-data'
                  => "$home/deleted-userdata/$fl/$sl/$login.xml",
   };
  
  %{$acis_web -> {'paths'}} = (%{$acis_web -> {'paths'}}, %$paths);
  
  debug "try load user-data";
  
  my $user_data_path = $paths -> {'user-data'};
  
  unless (-f $user_data_path)
   {
    $acis_web -> clear_process_queue;
    $acis_web -> set_presenter ('index');
   
    debug "user data file not exists";
    
    push @{$acis_web -> variables -> {'errors'}}, 'login-user-data-not-exists';
    
    return undef;
   } 
  
  my $user_data = load ACIS::Web::UserData ($user_data_path);
  
  return undef
   unless 
    (
     $login eq $user_data -> {'user'} -> {'login'} and
     $pass  eq $user_data -> {'user'} -> {'password'}
    );
  
  
  debug "check user-data lock";
  
  my $lock = $paths -> {'lock'};
  
  if (-f $lock and open LOCK, $lock)
   {
    debug "found lock file at '$lock'";
    
    $lock = <LOCK>;
    close LOCK;
    unless ( -f $lock and (-M $lock)*72 < 1 )
     {
      debug "found expired session in '$lock'";
      undef $lock;
     }
   }
  else
   {
    debug 'lock file not found';
    undef $lock;
   } 
   
  unless ($ACIS::DEBUG)
   {
    if ( defined $lock and $lock )
     {
      $acis_web -> clear_process_queue;
      $acis_web -> set_presenter ('index');
   
      debug "user data locked in $lock";
    
      # probably session used by other user
    
      push @{$acis_web -> variables -> {'errors'}}, 'login-user-data-lock';
      
      return undef;
     }
   }  
  
  return $user_data;
 }

1;

    
