<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='page'>
   <xsl:with-param name='title'>welcome</xsl:with-param>
   <xsl:with-param name='content'>
     
  <xsl:call-template name='registered-user-page-header'/>
  <div id='main'>
   <h1><xsl:choose><xsl:when test='not(contains(/data/user-name/text(), /data/record-name/text()))'><xsl:value-of select='/data/record-name/text()'/></xsl:when
    ><xsl:otherwise>Your</xsl:otherwise></xsl:choose> Profile:</h1>

   <p>Choose one of the following to change the profile:</p>

   <xsl:call-template name='user-menu'/>

  </div>
  <xsl:call-template name='registered-user-page-footer'/>
    </xsl:with-param>
   </xsl:call-template>
  </xsl:template>


</xsl:stylesheet>
