<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='registered-user-page'>
   <xsl:with-param name='title' >submit a new institution</xsl:with-param>
   <xsl:with-param name='content'>
    <h2>new institution</h2>
    <xsl:call-template name='display-human-readable-errors'/>
    <form xsl:use-attribute-sets='normal-form'>
     <xsl:call-template name='fieldset'>
      <xsl:with-param name='content' xmlns='http://x'>
       <p>
        <label class='form-field'>Institution name in its original language, required:<br />
         <input class='edit' name='name' size='50'/><br/>
        </label>
        
        <label class='form-field'>Institution name in English, optional:<br />
         <input class='edit' name='english-name' size='50'/><br/>
        </label>

        <label class='form-field'>Institution location, required:<br />
         <input class='edit' name='location' size='50'/><br/>
        </label>

        <label class='form-field'>Website address, required:<br />
         <input class='edit' name='homepage' size='50'/><br/>
        </label>

        <label class='form-field'>Email address, optional:<br />
         <input class='edit' name='email' size='50'/><br/>
        </label>
        
        <xsl:choose><xsl:when test='/data/form-data/handle/text()'
        >
        <label class='form-field'>postal<br />
         <input class='edit' name='postal' size='50'/><br/>
        </label>

        <label class='form-field'>phone<br />
         <input class='edit' name='phone' size='50'/><br/>
        </label>

        <label class='form-field'>fax<br />
         <input class='edit' name='fax' size='50'/><br/>
        </label>

        <input type='hidden' class='edit' name='handle'/>
        </xsl:when
        ><xsl:otherwise>
        <label class='form-field' for='add-institution'>add entered institution to my personal profile</label>
        <input type='checkbox' name='add-institution' id='add-institution' checked='yes' /><br/>
        </xsl:otherwise></xsl:choose>
        <input type='submit' name='action' value='submit'/>
       </p>
      </xsl:with-param>
     </xsl:call-template>
    </form>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>

</xsl:stylesheet>