<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='registered-user-page'>
   <xsl:with-param name='title'>photo upload</xsl:with-param>
   <xsl:with-param name='content'>
    <xsl:if test='/data/photo/text()'><h2>your photo</h2
    ><img src='{/data/photo/text()}'/>
    </xsl:if>
    <h2>upload<xsl:if test='/data/photo'> new</xsl:if> photo</h2>
    <xsl:call-template name='display-human-readable-errors'/>
    <form xsl:use-attribute-sets='file-submit-form'>
     <p>
      <label for='photo' class='form-field'>your photo:</label><br/>
      <input type='file' name='photo' id='photo'/><br/>
      <input type='submit' value='continue'/>
     </p>
    </form>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>

</xsl:stylesheet>
