<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='registered-user-page'>
   <xsl:with-param name='title'>Name and contact details</xsl:with-param>
   <xsl:with-param name='content'>
    <h1>Name and contact details</h1>

    <xsl:call-template name='display-human-readable-errors'/>
    <form xsl:use-attribute-sets='normal-form'>
     <h2>Your name</h2>
     <xsl:call-template name='fieldset'>
      <xsl:with-param name='content' xmlns='http://x'>
       <p>
        <label class='form-field'>Your full name, required:<br />
         <input class='edit' name='full-name' size='50'/>
        </label>
       </p>
       <p>
        <label class='form-field'>First name, required:<br/>
         <input class='edit' name='first-name' size='50'/>
        </label><br />
        <label class='form-field'>Middle name:<br />
         <input class='edit' name='middle-name' size='50'/>
        </label><br />
        <label class='form-field'>Last name, required:<br />
         <input class='edit' name='last-name' size='50'/>
        </label>
       </p>

       <p>
        <label class='form-field'>The variations of your name, one per line:<br />
         <textarea class='edit' name='name-variations' cols='50' rows='10'/>
        </label>
       </p>

       <h2>Contact details</h2>
       <p>
        <label class='form-field'>Email address (your login id). Must be a working
         address that you get email on.  Required: <br />
         <input class='edit' name="email" size="30" maxsize="60" />
        </label><br />

        <label class='form-field'><input class='edit' name="mail-pub" type="checkbox" value='true' /> Include the email in my
         public profile</label>
       </p>
              
       <p>
        <label class='form-field'>Your personal homepage, optional:<br />
         <input class='edit' name="homepage" size="50" maxsize="90" />
        </label><br />
                  
        <label class='form-field'>Your phone number, optional:<br />
         <input class='edit' name="phone" size="20" maxsize="40" />
        </label><br />
                    
        <label class='form-field'>Your postal address, optional:<br />
         <textarea class='edit' name="postal" type="text" rows="5" cols="50"/>
        </label>
       </p>
                
      </xsl:with-param>
     </xsl:call-template>
     <input type='submit' value='continue'/> 
    </form>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>

</xsl:stylesheet>
