<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='registered-user-page'>
   <xsl:with-param name='title'>user profile</xsl:with-param>
   <xsl:with-param name='content'>
    <h1><xsl:value-of select='/data/form-data/full-name'/></h1>
    <h2>names</h2>
    <p> 
     <xsl:call-template name='field-value'><xsl:with-param name='name' select='"first-name"'
      /></xsl:call-template>
     <xsl:if test='/data/form-data/middle-name/text()'
     ><xsl:call-template name='field-value'><xsl:with-param name='name' select='"middle-name"'
      /></xsl:call-template></xsl:if>
     <xsl:call-template name='field-value'><xsl:with-param name='name' select='"last-name"'
      /></xsl:call-template>
    </p> 
    <h2>contact details</h2>
    <p>
     <xsl:if test='/data/form-data/mail-pub/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"email"'
       /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/homepage/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"homepage"'
      /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/phone/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"phone"'
      /></xsl:call-template>
     </xsl:if>
     <xsl:if test='/data/form-data/postal/text()'>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"postal"'
      /></xsl:call-template>
     </xsl:if>
    </p>
    <xsl:if test='/data/affiliations'
     ><h2>affiliations</h2>
     <p>
      <ul
       ><xsl:apply-templates select='affiliations'
       /></ul>
     </p>
    </xsl:if>
    <xsl:if test='/data/form-data/sci-fields/text()'
     ><h2>areas of interests</h2>
     <p>
      <xsl:call-template name='field-value'><xsl:with-param name='name' select='"sci-fields"'
       /></xsl:call-template>
     </p>
    </xsl:if>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>



 <xsl:template match="*" mode='organization-details'>
<xsl:if test='text()' xml:space='preserve'
>    <li><xsl:value-of select='local-name(.)' />: <xsl:value-of select='text()'/></li>
</xsl:if>
 </xsl:template>


 <xsl:template match='affiliations/list-item|items/list-item' xml:space='preserve'>
  <li>
   <b><xsl:choose
   ><xsl:when test='homepage/text()'
   ><a href='{homepage/text()}'><xsl:value-of select='name/text()'/></a
   ></xsl:when
   ><xsl:otherwise><xsl:value-of select='name/text()'/></xsl:otherwise
   ></xsl:choose></b>
   <ul>
    <xsl:if test='email/text()'
    ><li>e-mail: <xsl:value-of select='email/text()' /></li></xsl:if>
    <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
   </ul>
  </li>
 </xsl:template>



</xsl:stylesheet>

