<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
   method='xml'
   doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
   doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
   omit-xml-declaration='yes'
   encoding='utf-8'/>
 
 <xsl:template match='text()'/>
  
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='registered-user-page'>
   <xsl:with-param name='title'>affiliations profile</xsl:with-param>
   <xsl:with-param name='content'>
    <h1>your details</h1>
     <xsl:if test='/data/affiliations'
     ><h2>you affiliated with:</h2>
      <p>
       <ul
        ><xsl:apply-templates select='affiliations'/>
       </ul>
      </p>
     </xsl:if>
     <h2>new search:</h2>
     <xsl:call-template name='display-human-readable-errors'/>
     <form xsl:use-attribute-sets='normal-form'>
      <p>
       <input type='hidden' name='action' value='search'/>
       <input name='search-what' value='{/data/form-data/search-what/text()}'
        /><input type='submit' value='search' />
       <br /><input type='radio' name='search-by' id='search-by-location' value='location' /> <label for='search-by-location' class='form-field'>by location</label>
       <input type='radio' name='search-by' id='search-by-name' value='name' checked='' /> <label for='search-by-name' class='form-field'>by name</label>
      </p>
     </form> 
      <p>
       <xsl:if test='/data/search'
       ><h2>last search yielded <xsl:value-of select='/data/search/results/text()'/> results:</h2>
       <ul><xsl:apply-templates select='search'/></ul>
       </xsl:if>
       <br/>
       <a href='{/data/base-url/text()}/new-institution!{/data/session/text()}'>submit an institution info</a>
       <br/>
       <input type='submit' name='action' value='continue' />
      </p>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>

 <xsl:template match="*" mode='organization-details'>
<xsl:if test='text()' xml:space='preserve'
>    <li><xsl:value-of select='local-name(.)' />: <xsl:value-of select='text()'/></li>
</xsl:if>
 </xsl:template>
 
 <xsl:template match="*" mode='correct-fields'
 ><xsl:if test='text()'><input type='hidden' name='{local-name(.)}' value='{text()}'
 /></xsl:if
 ></xsl:template>
 
 <xsl:template match='affiliations/list-item' xml:space='preserve'>
  <li>
   <form xsl:use-attribute-sets='normal-form'>
    <b><xsl:value-of select='name/text()'/></b><br/>
    <xsl:if test='homepage/text()'
    ><a href='{homepage/text()}'>homepage</a></xsl:if>
    <ul>
     <xsl:if test='email/text()'>
     <li>e-mail: <xsl:value-of select='email/text()' /></li></xsl:if>
     <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
    </ul>
    <input type='hidden' name='affiliation' value='{@pos}'/>
    <input type='submit' name='action' value='remove'/>
   </form>
   <xsl:if test='handle/text()'
   ><form xsl:use-attribute-sets='other-screen-form' action='{/data/base-url/text()}/new-institution!{/data/session/text()}'>
    <xsl:apply-templates select='name|postal|phone|fax|location|handle|homepage|email' mode='correct-fields'/>
    <input type='submit' name='action' value='correct'/>
   </form></xsl:if>
  </li>
 </xsl:template>

 <xsl:template match='search/items/list-item' xml:space='preserve'>
  <li>
   <form xsl:use-attribute-sets='normal-form'>
    <b><xsl:value-of select='name/text()'/></b><br />
    <xsl:if test='homepage/text()'
    ><a href='{homepage/text()}'>homepage</a></xsl:if>
    <ul>
     <xsl:if test='email/text()'>
     <li>e-mail: <xsl:value-of select='email/text()' /></li></xsl:if>
     <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
    </ul>
    <input type='hidden' name='affiliation' value='{@pos}'/>
    <input type='submit' name='action' value='add'/>
   </form>
  </li>
 </xsl:template>

 <!--xsl:template match='items/list-item' xml:space='preserve'>
  <li>
   <form xsl:use-attribute-sets='normal-form'>
    <b><xsl:choose
   ><xsl:when test='homepage/text()'>
    <a href='{homepage/text()}'><xsl:value-of select='name/text()'/></a>
   </xsl:when>
   <xsl:otherwise><xsl:value-of select='name/text()'/></xsl:otherwise>
   </xsl:choose></b>
   <xsl:variable name="action" xml:space='default'><xsl:choose
    ><xsl:when test='ancestor::affiliations'>remove</xsl:when
    ><xsl:otherwise>add</xsl:otherwise></xsl:choose
   ></xsl:variable>
   <ul>
    <xsl:if test='email/text()'>
    <li>e-mail: <xsl:value-of select='email/text()' /></li></xsl:if>
    <xsl:apply-templates select='postal|phone|fax|location' mode='organization-details'/>
   </ul>
   
      <input type='submit' name='action' value='{$action}'
       onclick='javascript:document.forms[0].elements["affiliation"].value="{@pos}"' />
    </form>  
   </li>
     
  </xsl:template-->



</xsl:stylesheet>

