<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
   method='xml'
   doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
   doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
   omit-xml-declaration='yes'
   encoding='utf-8'/>

 <xsl:template match='/data' xml:space='default'>
  <xsl:call-template name='page'>
   <xsl:with-param name='title' select='"new registration"'/>
   <xsl:with-param name='content'>
   <form xsl:use-attribute-sets='normal-form'>
   <xsl:call-template name='display-human-readable-errors'/>
   <xsl:call-template name='fieldset'>
    <xsl:with-param name='content' xmlns='http://x'>
     <h2>Login details</h2>
     <p>
      <label class='form-field'>Email address (your login id). 
        Must be a working address that you get email on. Required:<br />
      <input class='edit' name='e-mail' size='50'/></label><br />
     
      <label class='form-field'>
        <input class='checkbox' name="mail-pub" type="checkbox" value='true' /> Include the email in my
        public profile (will be hidden from spammers)</label>
        <br />
    </p>
    <p>
      <label class='form-field'>Password, at least 6 alpha-numeric 
      characters, required:<br />
      <input class='edit' name='pass' type='password'/></label><br />
      
      <label class='form-field'>Password confirmation, required:<br />
      <input class='edit' name='pass-confirm' type='password'/></label><br />
     </p>
     
     <h2>Your name</h2>
     <p>
      <label class='form-field'>First name, required:<br/>
       <input name='first-name' size='50'/>
      </label><br />

      <label class='form-field'>Middle name, optional:<br />
       <input name='middle-name' size='50'/>
      </label><br />

      <label class='form-field'>Last name, required:<br />
       <input name='last-name' size='50'/>
      </label><br />
     
     </p>
     
     <h2>Other</h2>
     <p>
      <label class='form-field'>A date (for identification purposes), YYYY-MM-DD, optional:<br />
       <input class='date-edit' name='year'  type='text' size='4' maxsize='4'/>-
       <input class='date-edit' name='month' type='text' size='2' maxsize='2'/>-
       <input class='date-edit' name='day'   type='text' size='2' maxsize='2'/>
      </label><br />
      
      <label class='form-field'>Your personal homepage, optional:<br />
       <input class='edit' name="homepage" size="50" maxsize="90" />
      </label><br />
     </p>
    
   </xsl:with-param>
  </xsl:call-template>
   <input type='submit' value='continue'/>
  </form>
  </xsl:with-param>
  </xsl:call-template>
  </xsl:template>

</xsl:stylesheet>
