<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='../general/pages.xsl'/>
 <xsl:import href='../general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>
 
 <xsl:template match='/data' xml:space='preserve'>
  <xsl:call-template name='page'>
   <xsl:with-param name='title'> registration: name variations and interests</xsl:with-param>
   <xsl:with-param name='content'>
   <form xsl:use-attribute-sets='normal-form'>
   <xsl:call-template name='display-human-readable-errors'/>
   <xsl:call-template name='fieldset'>
    <xsl:with-param name='content' xmlns='http://x'>
     <h2>Variations of your name</h2>
     <p>
      <label class='form-field'>The variations of your name, one per line:<br />
       <textarea class='edit' name='name-variations' cols='50' rows='10'/>
      </label><br />
     </p>
     <h2>Areas of academic interest</h2>
     <p>
      <label class='form-field'>Please list your areas of interest in academics.
       Type keywords or phrases, one per line. For example: 
       <pre>unemployment
emerging markets
market failures</pre>
       <textarea class='edit' name='sci-fields' cols='50' rows='6'/>
      </label><br />
     </p>
    </xsl:with-param>
   </xsl:call-template>
   <input type='submit' value='continue'/>
   </form>
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>