<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes= 'exsl'
 version="1.0">

 <xsl:import href='general/pages.xsl'/>
 <xsl:import href='general/forms.xsl'/>

 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'
  encoding='utf-8'/>

  <xsl:template match='text()'></xsl:template>      	

  <xsl:template match="data" xml:space='preserve'>
   <xsl:call-template name='page'>
    <xsl:with-param name='title'>Initial ACIS screen</xsl:with-param>
    <xsl:with-param name='headers'>
     <script>
     <![CDATA[
     function show_help (control)
      { control.innerHTML="<br/>if your browser supported cookie and it is enabled, you may save your login and pass and next login do not enter it<br/><br/>"; }]]>
     </script> 
    </xsl:with-param>
    <xsl:with-param name='content'>
  <h1>Welcome to ACIS</h1>
  <h2>Login</h2>
  <form xsl:use-attribute-sets='normal-form'>
   <p>If you have already registered in ACIS, logging in will allow you to
    update your contact information, workplace information and research profile.
    To log in enter your e-mail and the password entered in the initial
    registration process.</p>

   <xsl:call-template name='display-human-readable-errors'/>

   <xsl:call-template name='fieldset'>
    <xsl:with-param name='content' xmlns='http://x'>
     <label class='form-field'>login:<br />
     <input class='edit' name='login' /></label><br />

     <label class='form-field'>password:<br />
     <input class='edit' name='pass' type='password' /></label><br />

     <input type='checkbox' name='auto-login' id='auto-login' /><label for='auto-login' class='form-field'>save login and password</label>
    </xsl:with-param>
   </xsl:call-template>

<br />
   <span id='auto_login_help'> </span>
   <input type='submit' value='continue' />

   </form>

  <h2>Registration</h2>

  <p><a href='{/data/base-url/text()}/new-user'>Register as a new user</a>.</p>
  
  <h2>Forgot Password?</h2>
   <p>bla-bla <a href='{/data/base-url/text()}/forgotten-password'>Get it!</a>.</p>
  
    </xsl:with-param>
   </xsl:call-template>
  </xsl:template>


</xsl:stylesheet>

