<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes='exsl'
 version="1.0">
 
 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'/>
 
  <xsl:template name='registered-user-page-header'>
  <div id='header'>Hello, <xsl:value-of select='/data/user-name/text()'/>.<br /> 
   You may:
   <a href='{/data/base-url/text()}/properties!{/data/session/text()}'>change your properties</a>,
   <a href='{/data/base-url/text()}/logoff!{/data/session/text()}'>save all changes and logoff</a>.
   
  </div>
 </xsl:template>
 
 <xsl:template name='registered-user-page-footer'>
  <div id='footer'>
   ACIS: <a href='{/data/base-url/text()}'>Home</a> | 
   <a href='{/data/base-url/text()}/manual'>Manual</a> | 
   <a href='mailto:{/data/admin-email/text()}'>Site Administrator</a>
  </div>
 </xsl:template>
 
 <xsl:template name='registered-user-page' xml:space='preserve'>
  <xsl:param name='content'   />
  <xsl:param name='title'     />
  <xsl:param name='headers'   />
  <xsl:call-template name='page'
   ><xsl:with-param name='title'    select='$title'
   /><xsl:with-param name='headers' select='$headers'
   /><xsl:with-param name='content'>
  <xsl:call-template name='registered-user-page-header'/>
  <div id='main'>
   <h1><xsl:choose><xsl:when test='not(contains(/data/user-name/text(), /data/record-name/text()))'><xsl:value-of select='/data/record-name/text()'/></xsl:when
    ><xsl:otherwise>Your</xsl:otherwise></xsl:choose> Profile:</h1>
   <div id='user-menu'>
    <xsl:call-template name='user-menu'/>
   </div>
   <div id='contents'>
    <xsl:copy-of select='$content'/>
   </div>
  </div>
  <xsl:call-template name='registered-user-page-footer'/>
   </xsl:with-param
   ></xsl:call-template>
 </xsl:template>
 
 <xsl:template name='page' xml:space='preserve'>
  <xsl:param name='content'   />
  <xsl:param name='title'     />
  <xsl:param name='headers'   />
<html>
 <head>
   <title><xsl:value-of select='/data/site-name/text()'/>: <xsl:value-of select='$title'/></title>
  <link rel="stylesheet" href="/css/acis.css" type="text/css"/>
  <xsl:copy-of select='$headers'/>
 </head>
 <body>
  <xsl:copy-of select='$content'/>
 </body>
</html>
 </xsl:template>
 
  <xsl:template name='user-menu'>  
 <ul class='menu'>
   <li><a href='{/data/base-url/text()}/personal-data!{/data/session/text()}'
   >name and contact details</a></li>

   <li><a href='{/data/base-url/text()}/affiliation!{/data/session/text()}'
   >affiliation and employment profile</a></li>

   <li><a href='{/data/base-url/text()}/sci-fields!{/data/session/text()}'
   >scientific fields profile</a></li>
   
   <li><a href='{/data/base-url/text()}/photo!{/data/session/text()}'
   >upload photo</a></li>

   <li><a href='{/data/base-url/text()}/contribution!{/data/session/text()}'
   >academic contributions profile</a></li>

   <li><a href='{/data/base-url/text()}/unregister!{/data/session/text()}'
   >delete registration</a></li>
   
   <li><a href='{/data/base-url/text()}/logoff!{/data/session/text()}'
   >leave and save changes</a></li>
   
   <li><a href='{/data/base-url/text()}/outside-profile!{/data/session/text()}'
   >current state of the profile</a></li>
 </ul>

 </xsl:template>
 
  <xsl:template name='display-human-readable-errors'>
  <xsl:apply-templates select='/data/errors/list-item' mode='general-errors'/>
  <xsl:if test='/data/form-errors/required-absent/list-item'>
   <p class='error'>These fields are required:</p>
   <ul class='error'>
    <xsl:apply-templates select='/data/form-errors/required-absent/list-item' mode='form-errors'/>
   </ul>
  </xsl:if>
  <xsl:if test='/data/form-errors/invalid-values/list-item'>
   <p class='error'>The values you entered into these fields are invalid:</p>
   <ul class='error'>
    <xsl:apply-templates select='/data/form-errors/invalid-values/list-item' mode='form-errors'/>
   </ul>
  </xsl:if>
 </xsl:template>
  
 <xsl:template match='list-item' mode='form-errors'>
  <xsl:variable name='fields-table' select='document("../fields.xml")' />
  <xsl:variable name='name' select='text()'/>
  <li><xsl:value-of select='$fields-table/fields/field[@name=$name]/desc/text()'/>
  [<xsl:value-of select='$name'/>]</li>
 </xsl:template>
  
 <xsl:template match='list-item' mode='general-errors'>
  <xsl:variable name='errors-table' select='document("../errors.xml")' />
    <p class='error'>Error: <strong><xsl:value-of
    select='$errors-table/errors/error[@id=current()/text()]/text()'/> </strong>

   <!--   <xsl:if test='/data/debug/text()'>(code: -->
    <xsl:if test='1'> (code: <xsl:value-of select='text()'/>)</xsl:if
    >.</p>
 </xsl:template>
 
</xsl:stylesheet>