<xsl:stylesheet
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:exsl="http://exslt.org/common"
 exclude-result-prefixes='exsl'
 version="1.0">
 
 <xsl:output
  method='xml'
  doctype-public= '-//W3C//DTD XHTML 1.0 Strict//EN'
  doctype-system= 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd'/>
 
 <xsl:variable name='root' select='/'/>


 <xsl:template name='field-value' xml:space='preserve'
  ><xsl:param name='name' 
   /><xsl:variable name='fields-table' select='document("../fields.xml")' 
   /><xsl:variable name='text' select='$fields-table/fields/field[@name=$name]/desc/text()'
   /><span class='form-field'><xsl:value-of select='$text'/>: </span><br/>
    <span class='field-value'><xsl:value-of select='/data/form-data/*[@key=$name]/text()'/></span><br/>
 </xsl:template>

 <xsl:template name='input' xml:space='preserve'>
  <xsl:param name='name'
  /><xsl:variable name='fields-table' select='document("../fields.xml")' 
  /><xsl:variable name='text' select='$fields-table/fields/field[@name=$name]/desc/text()'
  /><label class='form-field' for='{$name}'><xsl:value-of select='$text'/>: </label><br/><input class='edit' name='{$name}' id='{$name}' value='{/data/form-data/*[@key=$name]/text()}'
  ><xsl:if test='contains(/data/form-errors//list-item/text(), $name)'><xsl:attribute name='class'>edit-highlight</xsl:attribute></xsl:if
  ></input><br/>
 </xsl:template>


 <!--  fieldset  -->

 <xsl:template name='fieldset'>
   <xsl:param name='content'/>

   <xsl:apply-templates mode='fs' select='exsl:node-set($content)' />
 </xsl:template>

 <xsl:template match='x:input[@type="text" or not(@type)]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='not(@class)'><xsl:attribute name='class'>edit</xsl:attribute></xsl:if>
     <xsl:attribute name='type'>text</xsl:attribute>
     <xsl:attribute name='value'>
       <xsl:value-of select='$root/data/form-data/*[@key=$name]/text()'/>
     </xsl:attribute>
     <xsl:if test='contains($root/data/form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>edit highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>

 <xsl:template match='x:input[@type="checkbox"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='$root/data/form-data/*[@key=$name]/text()'>
      <xsl:attribute name='checked'/>
     </xsl:if>
     <xsl:attribute name='value'>true</xsl:attribute>
     <xsl:attribute name='class'>checkbox</xsl:attribute>
     <xsl:if test='contains($root/data/form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>checkbox highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>

 <xsl:template match='x:input[@type="radio"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='contains(@value, $root/data/form-data/*[@key=$name]/text())'><xsl:attribute name='checked'/></xsl:if>
     <xsl:attribute name='class'>radio</xsl:attribute>
     <xsl:if test='contains($root/data/form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>radio highlight</xsl:attribute>
     </xsl:if>
   </xsl:element>
 </xsl:template>

 <xsl:template match='x:input[@type="hidden"]' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='input'>
     <xsl:copy-of select='@*'/>
     <xsl:attribute name='value'>
       <xsl:value-of select='$root/data/form-data/*[@key=$name]/text()'/>
     </xsl:attribute>
   </xsl:element>
 </xsl:template>

 
 
 <xsl:template match='x:textarea' mode='fs' xmlns:x='http://x'>
   <xsl:variable name='name' select='@name'/>
   <xsl:element name='textarea'>
     <xsl:copy-of select='@*'/>
     <xsl:if test='contains($root/data/form-errors//list-item/text(), $name)'>
       <xsl:attribute name='class'>highlight</xsl:attribute>
     </xsl:if>
     <xsl:value-of select='$root/data/form-data/*[@key=$name]/text()'/>
   </xsl:element>
 </xsl:template>

 <xsl:template match='x:*' mode='fs' xmlns:x='http://x'>
   <xsl:element name='{local-name()}'>
     <xsl:copy-of select="@*"/>
     <xsl:apply-templates mode='fs'/>
   </xsl:element>
 </xsl:template>


 <!--  end of fieldset -->


 <xsl:template name='textarea' xml:space='preserve'>
  <xsl:param name='name'
  /><xsl:variable name='fields-table' select='document("../fields.xml")' 
  /><xsl:variable name='text' select='$fields-table/fields/field[@name=$name]/desc/text()'
  /><label class='form-field' for='{$name}'><xsl:value-of select='$text'/>: </label><br/><textarea rows='5' name='{$name}' id='{$name}'><xsl:value-of select='/data/form-data/*[@key=$name]/text()'
  /><xsl:if test='contains(/data/form-errors//list-item/text(), $name)'><xsl:attribute name='class'>highlight</xsl:attribute></xsl:if
  ></textarea><br/>
 </xsl:template>


 
 <xsl:attribute-set name='normal-form'>
  <xsl:attribute name='action'><xsl:value-of select='/data/form-action/text()'/></xsl:attribute>
  <xsl:attribute name='method'>post</xsl:attribute>
  <xsl:attribute name='enctype'>application/x-www-form-urlencoded</xsl:attribute>
  <xsl:attribute name='accept-charset'>utf-8</xsl:attribute>
 </xsl:attribute-set>

 <xsl:attribute-set name='other-screen-form'>
  <xsl:attribute name='method'>post</xsl:attribute>
  <xsl:attribute name='enctype'>application/x-www-form-urlencoded</xsl:attribute>
  <xsl:attribute name='accept-charset'>utf-8</xsl:attribute>
 </xsl:attribute-set>

 <xsl:attribute-set name='file-submit-form'>
  <xsl:attribute name='action'><xsl:value-of select='/data/form-action/text()'/></xsl:attribute>
  <xsl:attribute name='method'>post</xsl:attribute>
  <xsl:attribute name='enctype'>multipart/form-data</xsl:attribute>
  <xsl:attribute name='accept-charset'>utf-8</xsl:attribute>
 </xsl:attribute-set>

  
</xsl:stylesheet>

