<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'
 version='1.0'>

 <xsl:import href='error.xsl' />
 <xsl:import href='text.xsl'  />
 <xsl:import href='common.xsl'/>

 <xsl:template name='form/initial'>
  <xsl:call-template name='form'>
   <xsl:with-param name='content'>
    <h3>names</h3>
    <p>
     <xsl:call-template name='text/new-user/initial/names' />

     <span class='form-field'>first name: </span
      ><xsl:call-template name='error/new-user/initial/first-name' /><br/>
      <input name='first-name' value='{/data/form-data/first-name/text()}'/><br/>
     <span class='form-field'>second name: </span
      ><xsl:call-template name='error/new-user/initial/second-name' /><br/>
      <input name='second-name' value='{/data/form-data/second-name/text()}'/><br/>
     <span class='form-field'>last name: </span
      ><xsl:call-template name='error/new-user/initial/last-name' /><br/>
      <input name='last-name' value='{/data/form-data/last-name/text()}'/><br/>
    </p>
 
    <h3>login details</h3>
    <p>
     e-mail: <xsl:call-template name='error/new-user/initial/e-mail' /><br/>
     <input name='e-mail' value='{/data/form-data/e-mail/text()}'/><br/>
     <xsl:choose
     ><xsl:when test='/data/form-data/mail-pub/text()'
     ><input name='mail-pub' type='checkbox' value='true' checked='' 
     /></xsl:when
     ><xsl:otherwise><input name='mail-pub' type='checkbox' value='true'
     /></xsl:otherwise></xsl:choose>Include the email in my
      public profile<br/>
     password: <xsl:call-template name='error/new-user/initial/pass' /><br/>
     <input name='pass' type='password'/><br/>
     password confirmation: <br/>
     <input name='pass-confirm' type='password'/><br/>
    </p>

    <h3>other</h3>
    <p>
     <xsl:call-template name='text/new-user/initial/date' /><br/>
     <input name='year'  type='text' size='4' maxsize='4' value='{/data/form-data/year/text()}'/>-
     <input name='month' type='text' size='2' maxsize='2' value='{/data/form-data/month/text()}'/>-
     <input name='day'   type='text' size='2' maxsize='2' value='{/data/form-data/day/text()}'/><br/>
     personal homepage: <xsl:call-template name='error/new-user/initial/homepage' /><br/>
     <input name='homepage' value='{/data/form-data/homepage/text()}'/><br/>
    </p>
    <br/>
    
   </xsl:with-param>
  </xsl:call-template>
 </xsl:template>

 <xsl:template name='view/initial'>
  <p>
  <span class='form-field'>full-name: </span><br/>
  <div class='field-value'>
   <xsl:value-of select='/data/form-data/full-name/text()'/>
  </div><br/>
  <span class='form-field'>
   <xsl:if test='/data/form-data/mail-pub/text()'>public </xsl:if>
   e-mail: </span><br/>
  <div class='field-value'>
   <xsl:value-of select='/data/form-data/e-mail/text()'/>
  </div><br/>
  <xsl:if test='/data/form-data/homepage/text()'>
   <span class='form-field'>personal homepage:</span> <br/>
   <div class='field-value'>
   <xsl:value-of select='/data/form-data/homepage/text()'/>
   </div><br/>
  </xsl:if>
  </p>
 </xsl:template>

 <xsl:template name='form-additional'>
 
  <form xsl:use-attribute-sets='normal-form'>
   <span class='form-field'>name variations</span><br/>
   <textarea name='name-variations' rows='11'
    ><xsl:copy-of select='/data/form-data/name-variations/text()'
    /></textarea><br/>
   <span class='form-field'>interests</span><br/>
   <textarea name='interests' rows='3'>
    <xsl:value-of select='/data/form-data/interests/text()' />
   </textarea><br/>
   <input type='submit' value='continue'/>
  </form>
 </xsl:template>

 <xsl:template name='view/additional'>
  <span class='form-field'>name variations:</span><br/>
  <div class='field-value'>
   <xsl:for-each select='/data/form-data/name-variations/list-item'>
    <xsl:value-of select='text()'/><br/>
   </xsl:for-each>
  </div>
  <xsl:if test='/data/form-data/interests/text()' >
   <span class='form-field'>interests:</span><br/>
   <div class='field-value'>
    <xsl:value-of select='/data/form-data/interests/text()'/>
   </div>
  </xsl:if>
 </xsl:template>
 <!--name='form/user/personal-data'-->

</xsl:stylesheet>