# -*- mode:perl -*-
use strict;

use AMF::Tests;
use AMF::Parser;
use AMF::Record;

sub wrap ($) {
  my $cont = shift;
  my $xml = <<WRAP;
<amf xmlns='http://amf.openlib.org'
     xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'
     xsi:schemaLocation='http://amf.openlib.org http://amf.openlib.org/2001/amf.xsd'>

$cont

</amf>
WRAP

}


{
  my $rec = AMF::Record -> new( ID => 'cactus(4&2<1)', 
                                TYPE => 'text' );
  
  my $john = AMF::Record -> new( TYPE => 'person' );
  $john -> adjective( 'name', {}, "John Galbraith" );
  $john -> adjective( 'homepage', {},
                      "http://some-bad-url.org/homepage?para=val&meter=ue"
                    );

  $rec -> verb( 'hasauthor', {}, $john );

  $rec -> adjective( 'abstract', {}, "It came to pass in those days, that a
  decree went out from Caesar August, <that all the world should be
  registered." );

  
  my $str = wrap $rec -> stringify;
  
  print "test1: ---$str---\n";
  test amf_parse_string $str;
}

