
package ReDIF::JELcodes;

# $Id: JELcodes.pm,v 1.11 2005/01/19 10:27:55 ivan Exp $
$VERSION = do { my @r=(q$Revision: 1.11 $=~/\d+/g); sprintf "%d."."%02d"x$#r,@r }; 


##########################################
#
# List of JEL codes used to make clasification.
# http://www.econlit.org/elclasjn.htm
#
#  reconstructed from
#  http://www.econlit.org/subject_descriptors.html
#  on 19 Jan 2005 (without deleteing the older ones).
#
##########################################

%JEL = (

 'A' => "General Economics and Teaching",
 'A0' => "General Economics and Teaching: General",
 'A00' => "General",
 'A1' => "General Economics",
 'A10' => "General Economics: General",
 'A11' => "Role of Economics; Role of Economists",
 'A12' => "Relation of Economics to Other Disciplines",
 'A13' => "Relation of Economics to Social Values",
 'A14' => "Sociology of Economics (citation analyses; departmental rankings; etc.)",
 'A19' => "General Economics: Other",
 'A2' => "Teaching of Economics",
 'A20' => "Economics Education and Teaching of Economics: General",
 'A21' => "Economics Education and Teaching of Economics: Pre-college",
 'A22' => "Economics Education and Teaching of Economics: Undergraduate",
 'A23' => "Economics Education and Teaching of Economics: Graduate",
 'A29' => "Economics Education and Teaching of Economics: Other",
 'A30' => "Multisubject Collective Works: General",
 'A31' => "Multisubject Collected Writings of Individuals",
 'A32' => "Multisubject Volumes",
 'A39' => "Multisubject Collective Works: Other",
 'B' => "Schools of Economic Thought and Methodology",
 'B0' => "Schools of Economic Thought and Methodology: General",
 'B00' => "Schools of Economic Thought and Methodology: General",
 'B1' => "History of Economic Thought through 1925",
 'B10' => "History of Economic Thought through 1925: General",
 'B11' => "History of Economic Thought: Preclassical (Ancient, Medieval, Mercantilist, Physiocratic)",
 'B12' => "History of Economic Thought: Classical (includes Adam Smith)",
 'B13' => "History of Economic Thought: Neoclassical through 1925 (includes Austrian, Marshallian, Walrasian)",
 'B14' => "History of Economic Thought through 1925: Socialist; Marxist",
 'B15' => "History of Economic Thought through 1925: Historical; Institutional ",
 'B16' => "History of Economic Thought: Quantitative",
 'B19' => "History of Economic Thought through 1925: Other",
 'B2' => "History of Economic Thought since 1925",
 'B20' => "History of Economic Thought since 1925: General",
 'B21' => "History of Economic Thought: Microeconomics",
 'B22' => "History of Economic Thought: Macroeconomics",
 'B23' => "History of Economic Thought: Econometrics; Quantitative Studies",
 'B24' => "History of Economic Thought since 1925: Socialist; Marxist",
 'B25' => "History of Economic Thought since 1925: Historical; Institutional; Evolutionary; Austrian",
 'B29' => "History of Economic Thought since 1925: Other",
 'B3' => "History of Thought: Individuals",
 'B30' => "History of Thought: Individuals: General",
 'B31' => "History of Thought: Individuals",
 'B4' => "Economic Methodology",
 'B40' => "Economic Methodology: General",
 'B41' => "Economic Methodology",
 'B49' => "Economic Methodology: Other",
 'B5' => "Current Heterodox Approaches",
 'B50' => "Current Heterodox Approaches: General",
 'B51' => "Current Heterodox Approaches: Socialist; Marxian; Sraffian",
 'B52' => "Current Heterodox Approaches: Institutional; Evolutionary",
 'B53' => "Current Heterodox Approaches: Austrian",
 'B59' => "Current Heterodox Approaches: Other",
 'C' => "Mathematical and Quantitative Methods",
 'C0' => "Mathematical and Quantitative Methods: General",
 'C00' => "Mathematical and Quantitative Methods: General",
 'C1' => "Econometric and Statistical Methods: General",
 'C10' => "Econometric and Statistical Methods: General",
 'C11' => "Bayesian Analysis",
 'C12' => "Hypothesis Testing",
 'C13' => "Estimation",
 'C14' => "Semiparametric and Nonparametric Methods",
 'C15' => "Statistical Simulation Methods; Monte Carlo Methods; Bootstrap Methods",
 'C16' => "Econometric and Statistical Methods: Specific Distributions",
 'C19' => "Econometric and Statistical Methods: Other",
 'C2' => "Econometric Methods: Single Equation Models",
 'C20' => "Econometric Methods: Single Equation Models; Single Variables: General",
 'C21' => "Econometric Methods: Single Equation Models; Single Variables: Cross-Sectional Models; Spatial Models; Treatment Effect Models",
 'C22' => "Econometric Methods: Single Equation Models; Single Variables: Time-Series Models",
 'C23' => "Econometric Methods: Single Equation Models; Single Variables: Models with Panel Data",
 'C24' => "Econometric Methods: Single Equation Models; Single Variables: Truncated and Censored Models",
 'C25' => "Econometric Methods: Single Equation Models; Single Variables: Discrete Regression and Qualitative Choice Models",
 'C29' => "Econometric Methods: Single Equation Models; Single Variables: Other",
 'C3' => "Econometric Methods: Multiple/Simultaneous Equation Models",
 'C30' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: General",
 'C31' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Cross-Sectional Models; Spatial Models; Treatment Effect Models",
 'C32' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Time-Series Models",
 'C33' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Models with Panel Data",
 'C34' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Truncated and Censored Models",
 'C35' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Discrete Regression and Qualitative Choice Models",
 'C39' => "Econometric Methods: Multiple/Simultaneous Equation Models; Multiple Variables: Other",
 'C4' => "Econometric and Statistical Methods: Special Topics",
 'C40' => "Econometric and Statistical Methods: Special Topics: General",
 'C41' => "Duration Analysis",
 'C42' => "Survey Methods",
 'C43' => "Index Numbers and Aggregation; leading indicators",
 'C44' => "Statistical Decision Theory; Operations Research",
 'C45' => "Neural Networks and Related Topics",
 'C49' => "Econometric and Statistical Methods: Special Topics: Other",
 'C5' => "Econometric Modeling",
 'C50' => "Econometric Modeling: General",
 'C51' => "Model Construction and Estimation",
 'C52' => "Model Evaluation and Testing",
 'C53' => "Forecasting and Other Model Applications",
 'C59' => "Econometric Modeling: Other",
 'C6' => "Mathematical Methods and Programming",
 'C60' => "Mathematical Methods and Programming: General",
 'C61' => "Optimization Techniques; Programming Models; Dynamic Analysis",
 'C62' => "Existence and Stability Conditions of Equilibrium",
 'C63' => "Computational Techniques",
 'C65' => "Miscellaneous Mathematical Tools",
 'C67' => "Input-Output Models",
 'C68' => "Computable General Equilibrium Models",
 'C69' => "Mathematical Methods and Programming: Other",
 'C7' => "Game Theory and Bargaining Theory",
 'C70' => "Game Theory and Bargaining Theory: General",
 'C71' => "Cooperative Games",
 'C72' => "Noncooperative Games",
 'C73' => "Stochastic and Dynamic Games; Evolutionary Games",
 'C78' => "Bargaining Theory; Matching Theory",
 'C79' => "Game Theory and Bargaining Theory: Other",
 'C8' => "Data Collection and Data Estimation Methodology; Computer Programs",
 'C80' => "Data Collection and Data Estimation Methodology; Computer Programs: General",
 'C81' => "Methodology for Collecting, Estimating, and Organizing Microeconomic Data",
 'C82' => "Methodology for Collecting, Estimating, and Organizing Macroeconomic Data",
 'C87' => "Econometric Software",
 'C88' => "Data Collection and Data Estimation Methodology; Computer Programs: Other Computer Software",
 'C89' => "Data Collection and Data Estimation Methodology; Computer Programs: Other",
 'C9' => "Design of Experiments",
 'C90' => "Design of Experiments: General",
 'C91' => "Design of Experiments: Laboratory, Individual",
 'C92' => "Design of Experiments: Laboratory, Group Behavior",
 'C93' => "Field Experiments",
 'C99' => "Design of Experiments: Other",
 'D' => "Microeconomics",
 'D0' => "Microeconomics: General",
 'D00' => "Microeconomics: General",
 'D01' => "Microeconomic Behavior: Underlying Principles",
 'D02' => "Institutions: Design, Formation, and Operations",
 'D1' => "Household Behavior",
 'D10' => "Household Behavior: General",
 'D11' => "Consumer Economics: Theory",
 'D12' => "Consumer Economics: Empirical Analysis",
 'D13' => "Household Production and Intrahousehold Allocation",
 'D14' => "Personal Finance",
 'D18' => "Consumer Protection",
 'D19' => "Household Behavior and Family Economics: Other",
 'D2' => "Production and Organizations",
 'D20' => "Production and Organizations: General",
 'D21' => "Firm Behavior",
 'D23' => "Organizational Behavior; Transaction Costs; Property Rights",
 'D24' => "Production; Capital and Total Factor Productivity; Capacity",
 'D29' => "Production and Organizations: Other",
 'D3' => "Distribution",
 'D30' => "Distribution: General",
 'D31' => "Personal Income, Wealth, and Their Distributions",
 'D33' => "Factor Income Distribution",
 'D39' => "Distribution: Other",
 'D4' => "Market Structure and Pricing",
 'D40' => "Market Structure and Pricing: General",
 'D41' => "Market Structure and Pricing: Perfect Competition",
 'D42' => "Market Structure and Pricing: Monopoly",
 'D43' => "Market Structure and Pricing: Oligopoly and Other Forms of Market Imperfection",
 'D44' => "Auctions",
 'D45' => "Rationing; Licensing",
 'D46' => "Value Theory",
 'D49' => "Market Structure and Pricing: Other",
 'D5' => "General Equilibrium and Disequilibrium",
 'D50' => "General Equilibrium and Disequilibrium: General",
 'D51' => "Exchange and Production Economies",
 'D52' => "Incomplete Markets",
 'D57' => "General Equilibrium and Disequilibrium: Input-Output Tables and Analysis",
 'D58' => "Computable and Other Applied General Equilibrium Models",
 'D59' => "General Equilibrium and Disequilibrium: Other",
 'D6' => "Welfare Economics",
 'D60' => "Welfare Economics: General",
 'D61' => "Allocative Efficiency; Cost-Benefit Analysis (contingent valuation)",
 'D62' => "Externalities",
 'D63' => "Equity, Justice, Inequality, and Other Normative Criteria and Measurement",
 'D64' => "Altruism",
 'D69' => "Welfare Economics: Other",
 'D7' => "Analysis of Collective Decision-Making",
 'D70' => "Analysis of Collective Decision-Making: General",
 'D71' => "Social Choice; Clubs; Committees; Associations",
 'D72' => "Economic Models of Political Processes: Rent-seeking, Elections, Legislatures, and Voting Behavior",
 'D73' => "Bureaucracy; Administrative Processes in Public Organizations; Corruption",
 'D74' => "Conflict; Conflict Resolution; Alliances",
 'D78' => "Positive Analysis of Policy-Making and Implementation",
 'D79' => "Analysis of Collective Decision-Making: Other",
 'D8' => "Information and Uncertainty",
 'D80' => "Information, Knowledge, and Uncertainty: General",
 'D81' => "Criteria for Decision-Making under Risk and Uncertainty",
 'D82' => "Asymmetric and Private Information",
 'D83' => "Search; Learning; Information and Knowledge",
 'D84' => "Expectations; Speculations",
 'D85' => "Network Formation ",
 'D86' => "Economics of Contract Law",
 'D89' => "Information and Uncertainty: Other",
 'D9' => "Intertemporal Choice and Growth",
 'D90' => "Intertemporal Choice and Growth: General",
 'D91' => "Intertemporal Consumer Choice; Life Cycle Models and Saving",
 'D92' => "Intertemporal Firm Choice and Growth, Investment, or Financing",
 'D99' => "Intertemporal Choice and Growth: Other",
 'E' => "Macroeconomics and Monetary Economics",
 'E0' => "Macroeconomics and Monetary Economics: General",
 'E00' => "Macroeconomics and Monetary Economics: General",
 'E01' => "Measurement and Data on National Income and Product Accounts and Wealth",
 'E1' => "General Aggregative Models",
 'E10' => "General Aggregative Models: General (includes measurement and data on national accounts and wealth)",
 'E11' => "General Aggregative Models: Marxian; Sraffian; Institutional; Evolutionary",
 'E12' => "General Aggregative Models: Keynes; Keynesian; Post-Keynesian",
 'E13' => "General Aggregative Models: Neoclassical (New Classical)",
 'E17' => "General Aggregative Models: Forecasting and Simulation",
 'E19' => "General Aggregative Models: Other",
 'E2' => "Consumption, Saving, Production, Employment, and Investment",
 'E20' => "Macroeconomics: Consumption, Saving, Production, Employment, and Investment: General (includes measurement and data)",
 'E21' => "Macroeconomics: Consumption; Saving",
 'E22' => "Macroeconomics: Capital; Investment (including Inventories); Capacity",
 'E23' => "Macroeconomics: Production",
 'E24' => "Macroeconomics: Employment; Unemployment; Wages; wage indexation",
 'E25' => "Aggregate Factor Income Distribution",
 'E26' => "Informal Economy; Underground Economy",
 'E27' => "Macroeconomics: Consumption, Saving, Production, Employment, and Investment: Forecasting and Simulation",
 'E29' => "Macroeconomics: Consumption, Saving, Production, Employment and Investment: Other",
 'E3' => "Prices, Business Fluctuations, and Cycles",
 'E30' => "Prices, Business Fluctuations, and Cycles: General (includes measurement and data)",
 'E31' => "Price Level; Inflation; Deflation",
 'E32' => "Business Fluctuations; Cycles",
 'E37' => "Prices, Business Fluctuations, and Cycles: Forecasting and Simulation",
 'E39' => "Prices, Business Fluctuations, and Cycles: Other",
 'E4' => "Money and Interest Rates",
 'E40' => "Money and Interest Rates: General (includes measurement and data)",
 'E41' => "Demand for Money",
 'E42' => "Monetary Systems; Standards; Regimes; Government and the Monetary System",
 'E43' => "Determination of Interest Rates; Term Structure of Interest Rates",
 'E44' => "Financial Markets and the Macroeconomy",
 'E47' => "Money and Interest Rates: Forecasting and Simulation",
 'E49' => "Money and Interest Rates: Other",
 'E5' => "Monetary Policy, Central Banking, and the Supply of Money and Credit",
 'E50' => "Monetary Policy, Central Banking, and the Supply of Money and Credit: General (flow of funds)",
 'E51' => "Money Supply; Credit; Money Multipliers",
 'E52' => "Monetary Policy (Targets, Instruments, and Effects)",
 'E53' => "Deposit Insurance",
 'E58' => "Central Banks and Their Policies (organization, case studies, lender of last resort issues)",
 'E59' => "Monetary Policy, Central Banking, and the Supply of Money and Credit: Other",
 'E6' => "Macroeconomic Aspects of Public Finance, Macroeconomic Policy, and General Outlook",
 'E60' => "Macroeconomic Policy Formation; Macroeconomic Aspects of Public Finance; Macroeconomic Policy; General Outlook: General",
 'E61' => "Policy Objectives; Policy Designs and Consistency; Policy Coordination",
 'E62' => "Macroeconomic Aspects of Fiscal Policy; Public Expenditures, Investment, and Finance; Taxation",
 'E63' => "Comparative or Joint Analysis of Fiscal and Monetary Policy; Stabilization Policy",
 'E64' => "Incomes Policy; Price Policy",
 'E65' => "Studies of Particular Policy Episodes",
 'E66' => "General Outlook and Conditions",
 'E69' => "Macroeconomic Aspects of Public Finance, Macroeconomic Policy, and General Outlook: Other",
 'F' => "International Economics",
 'F0' => "International Economics: General",
 'F00' => "International Economics: General",
 'F01' => "Global Outlook",
 'F02' => "International Economic Order; Noneconomic International Organizations; Economic Integration and Globalization: General",
 'F1' => "Trade",
 'F10' => "Trade: General",
 'F11' => "Neoclassical Models of Trade",
 'F12' => "Models of Trade with Imperfect Competition and Scale Economies",
 'F13' => "Commercial Policy; Protection; Promotion; Trade Negotiations; International Trade Organizations",
 'F14' => "Country and Industry Studies of Trade",
 'F15' => "Economic Integration",
 'F16' => "Trade and Labor Market Interactions",
 'F17' => "Trade: Forecasting and Simulation",
 'F18' => "Trade and Environment",
 'F19' => "Trade: Other",
 'F2' => "International Factor Movements and International Business",
 'F20' => "International Factor Movements and International Business: General",
 'F21' => "International Investment; Long-term Capital Movements",
 'F22' => "International Migration",
 'F23' => "Multinational Firms; International Business (International Competitiveness)",
 'F29' => "International Factor Movements: Other",
 'F3' => "International Finance",
 'F30' => "International Finance: General",
 'F31' => "Foreign Exchange (Exchange Rates; Intervention; Foreign Exchange Reserves; Currency Crises)",
 'F32' => "Current Account Adjustment; Short-term Capital Movements (Adjustment Programs)",
 'F33' => "International Monetary Arrangements and Institutions",
 'F34' => "International Lending and Debt Problems",
 'F35' => "Foreign Aid",
 'F36' => "Financial Aspects of Economic Integration",
 'F37' => "International Finance Forecasting and Simulation",
 'F39' => "International Finance: Other",
 'F4' => "Macroeconomic Aspects of International Trade and Finance",
 'F40' => "Macroeconomic Aspects of International Trade and Finance: General",
 'F41' => "Open Economy Macroeconomics",
 'F42' => "International Policy Coordination and Transmission",
 'F43' => "Economic Growth of Open Economies",
 'F47' => "Macroeconomic Aspects of International Trade and Finance: Forecasting and Simulation",
 'F49' => "Macroeconomic Aspects of International Trade and Finance: Other",
 'G' => "Financial Economics",
 'G0' => "Financial Economics: General",
 'G00' => "Financial Economics: General",
 'G1' => "General Financial Markets",
 'G10' => "General Financial Markets: General (includes measurement and data)",
 'G11' => "Portfolio Choice; Investment Decisions",
 'G12' => "Asset Pricing",
 'G13' => "Contingent Pricing; Futures Pricing; option pricing",
 'G14' => "Information and Market Efficiency; Event Studies",
 'G15' => "International Financial Markets",
 'G18' => "General Financial Markets: Government Policy and Regulation",
 'G19' => "General Financial Markets: Other",
 'G2' => "Financial Institutions and Services",
 'G20' => "Financial Institutions and Services: General",
 'G21' => "Banks; Other Depository Institutions; Mortgages",
 'G22' => "Insurance; Insurance Companies",
 'G23' => "Pension Funds; Other Private Financial Institutions; Institutional Investors",
 'G24' => "Investment Banking; Venture Capital;Brokerage",
 'G28' => "Financial Institutions and Services: Government Policy and Regulation",
 'G29' => "Financial Institutions and Services: Other",
 'G3' => "Corporate Finance and Governance",
 'G30' => "Corporate Finance and Governance: General",
 'G31' => "Capital Budgeting; Investment Policy; cost of capital",
 'G32' => "Financing Policy; Capital and Ownership Structure; financial ratios; value of firm",
 'G33' => "Bankruptcy; Liquidation",
 'G34' => "Mergers; Acquisitions; Restructuring; Voting; Proxy Contests; Corporate Governance",
 'G35' => "Payout Policy",
 'G38' => "Corporate Finance and Governance: Government Policy and Regulation",
 'G39' => "Corporate Finance and Governance: Other",
 'H' => "Public Economics",
 'H0' => "Public Economics: General",
 'H00' => "Public Economics: General",
 'H1' => "Structure and Scope of Government",
 'H10' => "Structure and Scope of Government: General",
 'H11' => "Structure, Scope, and Performance of Government",
 'H19' => "Structure and Scope of Government: Other",
 'H2' => "Taxation, Subsidies, and Revenue",
 'H20' => "Taxation, Subsidies, and Revenue: General",
 'H21' => "Taxation and Subsidies: Efficiency; Optimal Taxation ",
 'H22' => "Taxation and Subsidies: Incidence",
 'H23' => "Taxation and Subsidies: Externalities; Redistributive Effects; Environmental Taxes and Subsidies",
 'H24' => "Personal Income and Other Nonbusiness Taxes and Subsidies; includes inheritance and gift taxes",
 'H25' => "Business Taxes and Subsidies including sales and value-added (VAT)",
 'H26' => "Tax Evasion (Compliance, Collection)",
 'H27' => "Taxation, Subsidies, and Revenues: Other Sources of Revenue (Lottery)",
 'H29' => "Taxation and Subsidies: Other",
 'H3' => "Fiscal Policies and Behavior of Economic Agents",
 'H30' => "Fiscal Policies and Behavior of Economic Agents: General",
 'H31' => "Fiscal Policies and Behavior of Economic Agents: Household (effects on labor supply)",
 'H32' => "Fiscal Policies and Behavior of Economic Agents: Firm",
 'H39' => "Fiscal Policies and Behavior of Economic Agents: Other",
 'H4' => "Publicly Provided Goods",
 'H40' => "Publicly Provided Goods: General",
 'H41' => "Public Goods",
 'H42' => "Publicly Provided Private Goods",
 'H43' => "Project Evaluation; Social Discount Rate",
 'H49' => "Publicly Provided Goods: Other",
 'H5' => "National Government Expenditures and Related Policies",
 'H50' => "National Government Expenditures and Related Policies: General",
 'H51' => "National Government Expenditures and Health",
 'H52' => "National Government Expenditures and Education",
 'H53' => "National Government Expenditures and Welfare Programs",
 'H54' => "National Government Expenditures and Related Policies: Infrastructures; Other Public Investment and Capital Stock",
 'H55' => "Social Security and Public Pensions",
 'H56' => "National Security and War",
 'H57' => "National Government Expenditures and Related Policies: Procurement",
 'H59' => "National Government Expenditures and Related Policies: Other",
 'H6' => "National Budget, Deficit, and Debt",
 'H60' => "National Budget, Deficit, and Debt: General",
 'H61' => "National Budget; Budget Systems",
 'H62' => "National Deficit; Surplus",
 'H63' => "National Debt; Debt Management",
 'H69' => "National Budget, Deficit, and Debt: Other",
 'H7' => "State and Local Government; Intergovernmental Relations",
 'H70' => "State and Local Government; Intergovernmental Relations: General",
 'H71' => "State and Local Taxation, Subsidies, and Revenue",
 'H72' => "State and Local Budget and Expenditures",
 'H73' => "State and Local Government; Intergovernmental Relations: Interjurisdictional Differentials and Their Effects",
 'H74' => "State and Local Borrowing",
 'H77' => "Intergovernmental Relations; Federalism",
 'H79' => "State and Local Government; Intergovernmental Relations: Other",
 'H8' => "Miscellaneous Issues",
 'H80' => "Public Economics: Miscellaneous Issues: General",
 'H81' => "Governmental Loans, Loan Guarantees,  and Credits",
 'H82' => "Governmental Property",
 'H83' => "Public Administration",
 'H87' => "International Fiscal Issues; International Public Goods",
 'H89' => "Public Economics: Miscellaneous Issues: Other",
 'I' => "Health, Education, and Welfare",
 'I0' => "Health, Education, and Welfare: General",
 'I00' => "Health, Education, and Welfare: General",
 'I1' => "Health",
 'I10' => "Health: General",
 'I11' => "Analysis of Health Care Markets",
 'I12' => "Health Production: Nutrition, Mortality, Morbidity, Substance Abuse and Addiction, Disability, and Economic Behavior",
 'I18' => "Health: Government Policy; Regulation; Public Health",
 'I19' => "Health: Other",
 'I2' => "Education",
 'I20' => "Education: General",
 'I21' => "Analysis of Education",
 'I22' => "Educational Finance",
 'I23' => "Higher Education Research Institutions",
 'I28' => "Education: Government Policy",
 'I29' => "Education: Other",
 'I3' => "Welfare and Poverty",
 'I30' => "Welfare and Poverty: General",
 'I31' => "General Welfare; Basic Needs; Living Standards; Quality of Life; Happiness",
 'I32' => "Measurement and Analysis of Poverty",
 'I38' => "Welfare and Poverty: Government Programs; Provision and Effects of Welfare Programs",
 'I39' => "Welfare and Poverty: Other",
 'J' => "Labor and Demographic Economics",
 'J0' => "Labor and Demographic Economics: General",
 'J00' => "Labor and Demographic Economics: General",
 'J1' => "Demographic Economics",
 'J10' => "Demographic Economics: General",
 'J11' => "Demographic Trends and Forecasts; General Migration",
 'J12' => "Marriage; Marital Dissolution; Family Structure",
 'J13' => "Fertility; Family Planning; Child Care; Children; Youth",
 'J14' => "Economics of the Elderly; Economics of the Handicapped",
 'J15' => "Economics of Minorities and Races; Non-labor Discrimination",
 'J16' => "Economics of Gender; Non-labor Discrimination",
 'J17' => "Value of Life; Foregone Income",
 'J18' => "Demographic Economics: Public Policy",
 'J19' => "Demographic Economics: Other",
 'J2' => "Time Allocation; Work Behavior; Employment Determination and Creation",
 'J20' => "Time Allocation; Work Behavior; Employment Determination and Creation; Human Capital",
 'J21' => "Labor Force and Employment, Size, and Structure (by industry, occupation, demographic characteristics, etc.)",
 'J22' => "Time Allocation and Labor Supply (hours of work, part-time employment, temporary workers, work sharing, absenteeism, quits, work-life balance)",
 'J23' => "Employment Determination; Job Creation; Demand for Labor; Self-Employment",
 'J24' => "Human Capital; Skills; Occupational Choice; Labor Productivity (Formal Training Programs; On-the-Job Training)",
 'J26' => "Retirement; Retirement Policies",
 'J28' => "Safety; Accidents; Industrial Health; Job Satisfaction; Related Public Policy (workmen's compensation)",
 'J29' => "Time Allocation, Work Behavior, and Employment Determination: Other",
 'J3' => "Wages, Compensation, and Labor Costs",
 'J30' => "Wages, Compensation, and Labor Costs: General",
 'J31' => "Wage Level and Structure; Wage Differentials by Skill, Training, Occupation, etc. (industry, schooling, experience, tenure, cohort, etc.)",
 'J32' => "Nonwage Labor Costs and Benefits; Private Pensions (fringe benefits, cost of social security, costs of hiring and firing, family support programs)",
 'J33' => "Compensation Packages; Payment Methods (piece rates, time rates, bonuses, profit-sharing)",
 'J38' => "Wages, Compensation, and Labor Costs: Public Policy (wage subsidies, minimum wage legislation)",
 'J39' => "Wages, Compensation, and Labor Costs: Other",
 'J4' => "Particular Labor Markets",
 'J40' => "Particular Labor Markets: General",
 'J41' => "Contracts: Specific Human Capital, Matching Models, Efficiency Wage Models, and Internal Labor Markets (other contracts)",
 'J42' => "Monopsony; Segmented Labor Markets",
 'J43' => "Agricultural Labor Markets",
 'J44' => "Professional Labor Markets and Occupations ",
 'J45' => "Public Sector Labor Markets",
 'J48' => "Particular Labor Markets: Public Policy",
 'J49' => "Particular Labor Markets: Other",
 'J5' => "Labor-Management Relations, Trade Unions, and Collective Bargaining",
 'J50' => "Labor-Management Relations, Trade Unions, and Collective Bargaining: General",
 'J51' => "Trade Unions: Objectives, Structure, and Effects",
 'J52' => "Dispute Resolution: Strikes, Arbitration, and Mediation; Collective Bargaining",
 'J53' => "Labor-Management Relations; Industrial Jurisprudence ",
 'J54' => "Producer Cooperatives; Labor Managed Firms",
 'J58' => "Labor-Management Relations, Trade Unions, and Collective Bargaining: Public Policy",
 'J59' => "Labor-Management Relations, Trade Unions, and Collective Bargaining: Other",
 'J6' => "Mobility, Unemployment, and Vacancies",
 'J60' => "Mobility, Unemployment, and Vacancies: General",
 'J61' => "Geographic Labor Mobility; Immigrant Workers",
 'J62' => "Job, Occupational, and Intergenerational Mobility; Promotion",
 'J63' => "Labor Turnover; Vacancies; Layoffs (includes separations, hires, redundancy, job tenure, displaced workers)",
 'J64' => "Unemployment: Models, Duration, Incidence, and Job Search",
 'J65' => "Unemployment Insurance; Severance Pay; Plant Closings",
 'J68' => "Mobility, Unemployment, and Vacancies: Public Policy (Employment Services)",
 'J69' => "Mobility, Unemployment, and Vacancies: Other",
 'J7' => "Discrimination",
 'J70' => "Labor Discrimination: General",
 'J71' => "Labor Discrimination (hiring and firing)",
 'J78' => "Labor Discrimination: Public Policy (including comparable worth)",
 'J79' => "Labor Discrimination: Other",
 'J8' => "Labor Standards: National and International",
 'J80' => "Labor Standards: National and International: General",
 'J81' => "Labor Standards: National and International: Working Conditions (safety, hours)",
 'J82' => "Labor Standards: National and International: Labor Force Composition (child labor, prison labor, bonded labor, immigrant labor, migrant workers, racial and gender discrimination)",
 'J83' => "Labor Standards: National and International: Workers' Rights",
 'J88' => "Labor Standards: National and International: Public Policy",
 'J89' => "Labor Standards: National and International: Other",
 'K' => "Law and Economics",
 'K0' => "Law and Economics: General",
 'K00' => "Law and Economics: General",
 'K1' => "Basic Areas of Law",
 'K10' => "Basic Areas of Law: General (constitutional law)",
 'K11' => "Property Law",
 'K12' => "Contract Law",
 'K13' => "Tort Law and Product Liability",
 'K14' => "Criminal Law",
 'K19' => "Basic Areas of Law: Other",
 'K2' => "Regulation and Business Law",
 'K20' => "Regulation and Business Law: General",
 'K21' => "Antitrust Law",
 'K22' => "Corporation and Securities Law",
 'K23' => "Regulated Industries and Administrative Law",
 'K29' => "Regulation and Business Law: Other",
 'K3' => "Other Substantive Areas of Law",
 'K30' => "Other Substantive Areas of Law: General",
 'K31' => "Labor Law",
 'K32' => "Environmental, Health, and Safety Law",
 'K33' => "International Law",
 'K34' => "Tax Law",
 'K35' => "Personal Bankruptcy Law",
 'K39' => "Other Substantive Areas of Law: Other",
 'K4' => "Legal Procedure, the Legal System, and Illegal Behavior",
 'K40' => "Legal Procedure, the Legal System, and Illegal Behavior: General",
 'K41' => "Litigation Process",
 'K42' => "Illegal Behavior and the Enforcement of Law",
 'K49' => "Legal Procedure, the Legal System, and Illegal Behavior: Other",
 'L' => "Industrial Organization",
 'L0' => "Industrial Organization: General",
 'L00' => "Industrial Organization: General",
 'L1' => "Market Structure, Firm Strategy, and Market Performance",
 'L10' => "Market Structure, Firm Strategy, and Market Performance: General",
 'L11' => "Production, Pricing, and Market Structure; Size Distribution of Firms (Concentration, Product Differentiation, Entry and Exit)",
 'L12' => "Market Structure, Firm Strategy, and Market Performance: Monopoly; Monopolization Strategies (cartels; collusion)",
 'L13' => "Market Structure, Firm Strategy, and Market Performance: Oligopoly and Other Imperfect Markets; monopolistic competition; contestable markets",
 'L14' => "Transactional Relationships; Contracts and Reputation; Networks",
 'L15' => "Information and Product Quality; Standardization and Compatibility",
 'L16' => "Industrial Organization and Macroeconomic Industrial Structure; Industrial Price Indices",
 'L19' => "Market Structure, Firm Strategy, and Market Performance: Other",
 'L2' => "Firm Objectives, Organization, and Behavior",
 'L20' => "Firm Objectives, Organization, and Behavior: General",
 'L21' => "Business Objectives of the Firm",
 'L22' => "Firm Organization and Market Structure: Markets vs. Hierarchies; Vertical Integration; Conglomerates",
 'L23' => "Organization of Production",
 'L24' => "Contracting Out; Joint Ventures",
 'L25' => "Firm Performance: Size, Age, Profit, and Sales",
 'L29' => "Firm Objectives, Organization, and Behavior: Other",
 'L3' => "Nonprofit Organizations and Public Enterprise",
 'L30' => "Nonprofit Organizations and Public Enterprise: General",
 'L31' => "Nonprofit Institutions; NGOs (foundations, etc.)",
 'L32' => "Public Enterprises",
 'L33' => "Comparison of Public and Private Enterprises; Privatization; Contracting Out",
 'L39' => "Nonprofit Organizations and Public Enterprise: Other",
 'L4' => "Antitrust Policy",
 'L40' => "Antitrust Issues and Policies: General",
 'L41' => "Monopolization; Horizontal Anticompetitive Practices",
 'L42' => "Vertical Restraints; Resale Price Maintenance; Quantity Discounts",
 'L43' => "Legal Monopolies and Regulation or Deregulation",
 'L44' => "Antitrust Policy and Public Enterprise, Nonprofit Institutions, and Professional Organizations",
 'L49' => "Antitrust Policy: Other",
 'L5' => "Regulation and Industrial Policy",
 'L50' => "Regulation and Industrial Policy: General",
 'L51' => "Economics of Regulation",
 'L52' => "Industrial Policy; Sectoral Planning Methods",
 'L53' => "Government Promotion of Firms",
 'L59' => "Regulation and Industrial Policy: Other",
 'L6' => "Industry Studies: Manufacturing",
 'L60' => "Industry Studies: Manufacturing: General",
 'L61' => "Metals and Metal Products; Cement; Glass; Ceramics",
 'L62' => "Automobiles; Other Transportation Equipment",
 'L63' => "Microelectronics; Computers; Communications Equipment",
 'L64' => "Other Machinery; Business Equipment; Armaments",
 'L65' => "Chemicals; Rubber; Drugs; Biotechnology ",
 'L66' => "Food; Beverages; Cosmetics; Tobacco",
 'L67' => "Other Consumer Nondurables: Clothing, Textiles, Shoes, and Leather",
 'L68' => "Appliances; Other Consumer Durables",
 'L69' => "Industry Studies: Manufacturing: Other",
 'L7' => "Industry Studies: Primary Products and Construction",
 'L70' => "Industry Studies: Primary Products and Construction: General",
 'L71' => "Mining, Extraction, and Refining: Hydrocarbon Fuels",
 'L72' => "Mining, Extraction, and Refining: Other Nonrenewable Resources",
 'L73' => "Forest Products: Lumber and Paper",
 'L74' => "Construction",
 'L78' => "Industry Studies: Primary Products and Construction: Government Policy",
 'L79' => "Industry Studies: Primary Products and Construction: Other",
 'L8' => "Industry Studies: Services",
 'L80' => "Industry Studies: Services: General",
 'L81' => "Retail and Wholesale Trade; Warehousing; e-Commerce",
 'L82' => "Entertainment; Media (performing arts, visual arts broadcasting, publishing, etc.)",
 'L83' => "Sports; Gambling; Recreation; Tourism",
 'L84' => "Personal, Professional, and Business Services (Lawyers, Accountants, Barbers, Beauticians, Consultants, Opticians, etc.)",
 'L85' => "Real Estate Services",
 'L86' => "Information and Internet Services; Computer Software",
 'L87' => "Postal and Delivery Services",
 'L88' => "Industry Studies: Services: Government Policy",
 'L89' => "Industry Studies: Services: Other",
 'L9' => "Industry Studies: Utilities and Transportation",
 'L90' => "Industry Studies: Transportation and Utilities: General",
 'L91' => "Transportation: General",
 'L92' => "Railroads and Other Surface Transportation: Autos, Buses, Trucks, and Water Carriers; Ports (trains, boats, ships, ocean liners, etc.)",
 'L93' => "Air Transportation (airlines)",
 'L94' => "Electric Utilities (power plants)",
 'L95' => "Gas Utilities; Pipelines; Water Utilities",
 'L96' => "Telecommunications",
 'L97' => "Utilities: General",
 'L98' => "Industry Studies: Utilities and Transportation: Government Policy",
 'L99' => "Industry Studies: Utilities and Transportation: Other",
 'M' => "Business Administration and Business Economics; Marketing; Accounting",
 'M0' => "Business Administration and Business Economics; Marketing; Accounting: General",
 'M00' => "Business Administration and Business Economics; Marketing; Accounting: General",
 'M1' => "Business Administration",
 'M10' => "Business Administration: General",
 'M11' => "Production Management",
 'M12' => "Personnel Management; executive compensation",
 'M13' => "Entrepreneurship (New Firms; Startups)",
 'M14' => "Corporate Culture; Social Responsibility",
 'M19' => "Business Administration: Other",
 'M2' => "Business Economics",
 'M20' => "Business Economics: General",
 'M21' => "Business Economics",
 'M29' => "Business Economics: Other",
 'M3' => "Marketing and Advertising",
 'M30' => "Marketing and Advertising: General",
 'M31' => "Marketing",
 'M37' => "Advertising",
 'M39' => "Marketing and Advertising: Other",
 'M4' => "Accounting",
 'M40' => "Accounting and Auditing: General",
 'M41' => "Accounting",
 'M42' => "Auditing",
 'M49' => "Accounting: Other",
 'M5' => "Personnel Economics",
 'M50' => "Personnel Economics: General",
 'M51' => "Personnel Economics: Firm Employment Decisions; Promotions (hiring, firing, turnover, part-time, temporary workers, seniority issues)",
 'M52' => "Personnel Economics: Compensation and Compensation Methods and Their Effects (stock options, fringe benefits, incentives, family support programs, seniority issues)",
 'M53' => "Personnel Economics: Training",
 'M54' => "Personnel Economics: Labor Management (team formation, worker empowerment, job design, tasks and authority, job satisfaction)",
 'M55' => "Personnel Economics: Labor Contracting: Outsourcing; Franchising: Other ",
 'M59' => "Personnel Economics: Other",
 'N' => "Economic History",
 'N0' => "Economic History: General",
 'N00' => "Economic History: General",
 'N01' => "Development of the Discipline: Historiographical; Sources and Methods",
 'N1' => "Macroeconomics and Monetary Economics; Growth and Fluctuations",
 'N10' => "Economic History: Macroeconomics and Monetary Economics; Growth and Fluctuations: General, International, or Comparative",
 'N11' => "Economic History: Macroeconomics; Growth and Fluctuations: U.S.; Canada: Pre-1913",
 'N12' => "Economic History: Macroeconomics; Growth and Fluctuations: U.S.; Canada: 1913-",
 'N13' => "Economic History: Macroeconomics; Growth and Fluctuations: Europe: Pre-1913",
 'N14' => "Economic History: Macroeconomics; Growth and Fluctuations: Europe: 1913-",
 'N15' => "Economic History: Macroeconomics; Growth and Fluctuations: Asia including Middle East",
 'N16' => "Economic History: Macroeconomics; Growth and Fluctuations: Latin America; Caribbean",
 'N17' => "Economic History: Macroeconomics; Growth and Fluctuations: Africa; Oceania",
 'N2' => "Financial Markets and Institutions",
 'N20' => "Economic History: Financial Markets and Institutions: General, International, or Comparative (exchange rates; debt)",
 'N21' => "Economic History: Financial Markets and Institutions: U.S.; Canada: Pre-1913",
 'N22' => "Economic History: Financial Markets and Institutions: U.S.; Canada: 1913-",
 'N23' => "Economic History: Financial Markets and Institutions: Europe: Pre-1913",
 'N24' => "Economic History: Financial Markets and Institutions: Europe: 1913-",
 'N25' => "Economic History: Financial Markets and Institutions: Asia including Middle East",
 'N26' => "Economic History: Financial Markets and Institutions: Latin America; Caribbean",
 'N27' => "Economic History: Financial Markets and Institutions: Africa; Oceania",
 'N3' => "Labor and Consumers, Demography, Education, Income and Wealth",
 'N30' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: General, International, or Comparative (Migration)",
 'N31' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: U.S.; Canada: Pre-1913",
 'N32' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: U.S.; Canada: 1913-",
 'N33' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: Europe: Pre-1913",
 'N34' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: Europe: 1913-",
 'N35' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: Asia including Middle East",
 'N36' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: Latin America; Caribbean",
 'N37' => "Economic History: Labor and Consumers, Demography, Education, Income and Wealth: Africa; Oceania",
 'N4' => "Government, War, Law, and Regulation",
 'N40' => "Economic History: Government, War, Law, and Regulation: General, International, or Comparative",
 'N41' => "Economic History: Government, War, Law, and Regulation: U.S.; Canada: Pre-1913",
 'N42' => "Economic History: Government, War, Law, and Regulation: U.S.; Canada: 1913-",
 'N43' => "Economic History: Government, War, Law, and Regulation: Europe: Pre-1913",
 'N44' => "Economic History: Government, War, Law, and Regulation: Europe: 1913-",
 'N45' => "Economic History: Government, War, Law, and Regulation: Asia including Middle East",
 'N46' => "Economic History: Government, War, Law, and Regulation: Latin America; Caribbean",
 'N47' => "Economic History: Government, War, Law, and Regulation: Africa; Oceania",
 'N5' => "Agriculture, Natural Resources, Environment, and Extractive Industries",
 'N50' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: General, International, or Comparative",
 'N51' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: U.S.; Canada: Pre-1913",
 'N52' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: U.S.; Canada: 1913-",
 'N53' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: Europe: Pre-1913",
 'N54' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: Europe: 1913-",
 'N55' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: Asia including Middle East",
 'N56' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: Latin America; Caribbean",
 'N57' => "Economic History: Agriculture, Natural Resources, Environment, and Extractive Industries: Africa; Oceania",
 'N6' => "Manufacturing and Construction",
 'N60' => "Economic History: Manufacturing and Construction (includes Housing): General, International, or Comparative (multinational firms)",
 'N61' => "Economic History: Manufacturing and Construction (includes Housing): U.S.; Canada: Pre-1913",
 'N62' => "Economic History: Manufacturing and Construction (includes Housing): U.S.; Canada: 1913-",
 'N63' => "Economic History: Manufacturing and Construction (includes Housing): Europe: Pre-1913",
 'N64' => "Economic History: Manufacturing and Construction (includes Housing): Europe: 1913-",
 'N65' => "Economic History: Manufacturing and Construction (includes Housing): Asia including Middle East",
 'N66' => "Economic History: Manufacturing and Construction (includes Housing): Latin America; Caribbean",
 'N67' => "Economic History: Manufacturing and Construction (includes Housing): Africa; Oceania",
 'N7' => "Transport, International and Domestic Trade, Energy, and Other Services",
 'N70' => "Economic History: Transport, International and Domestic Trade, Energy, Technology, and Other Services (includes Health Services): General, International, or Comparative",
 'N71' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): U.S.; Canada: Pre-1913",
 'N72' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): U.S.; Canada: 1913-",
 'N73' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): Europe: Pre-1913",
 'N74' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): Europe: 1913-",
 'N75' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): Asia including Middle East",
 'N76' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (include Health Services): Latin America; Caribbean",
 'N77' => "Economic History: Transport, Trade, Energy, Technology, and Other Services (includes Health Services): Africa; Oceania",
 'N8' => "Micro-Business History",
 'N80' => "Micro-Business History: General, International, or Comparative",
 'N81' => "Micro-Business History: U.S.; Canada: Pre-1913",
 'N82' => "Micro-Business History: U.S.; Canada: 1913-",
 'N83' => "Micro-Business History: Europe: Pre-1913",
 'N84' => "Micro-Business History: Europe: 1913-",
 'N85' => "Micro-Business History: Asia including Middle East",
 'N86' => "Micro-Business History: Latin America; Caribbean",
 'N87' => "Micro-Business History: Africa; Oceania",
 'N9' => "Regional and Urban History",
 'N90' => "Regional and Urban History: General",
 'N91' => "Regional and Urban History: U.S.; Canada: Pre-1913",
 'N92' => "Regional and Urban History: U.S.; Canada: 1913-",
 'N93' => "Regional and Urban History: Europe: Pre-1913",
 'N94' => "Regional and Urban History: Europe: 1913-",
 'N95' => "Regional and Urban History: Asia including Middle East",
 'N96' => "Regional and Urban History: Latin America; Caribbean",
 'N97' => "Regional and Urban History: Africa; Oceania",
 'O' => "Economic Development, Technological Change, and Growth",
 'O0' => "Economic Development, Technological Change, and Growth: General",
 'O00' => "General",
 'O1' => "Economic Development",
 'O10' => "Economic Development: General",
 'O11' => "Macroeconomic Analyses of Economic Development (includes macro models and analyses of patterns and determinants of development)",
 'O12' => "Microeconomic Analyses of Economic Development (includes macro models)",
 'O13' => "Economic Development: Agriculture; Natural Resources; Energy; Environment; Other Primary Products",
 'O14' => "Industrialization; Manufacturing and Service Industries; Choice of Technology",
 'O15' => "Economic Development: Human Resources; Human Development; Income Distribution; Migration (nutrition, health, education, fertility, household structure and formation, labor markets)",
 'O16' => "Economic Development: Financial Markets; Saving and Capital Investment (Financial Intermediation)",
 'O17' => "Formal and Informal Sectors; Shadow Economy; Institutional Arrangements: Legal, Social, Economic, and Political",
 'O18' => "Economic Development: Regional, Urban, and Rural Analyses",
 'O19' => "International Linkages to Development; Role of International Organizations (includes international assistance programs, trade and financial flows; IMF conditionality)",
 'O2' => "Development Planning and Policy",
 'O20' => "Development Planning and Policy: General",
 'O21' => "Planning Models; Planning Policy (includes input-output models and computable general equilibrium models)",
 'O22' => "Project Analysis",
 'O23' => "Fiscal and Monetary Policy in Development",
 'O24' => "Development Planning and Policy: Trade Policy; Factor Movement; Foreign Exchange Policy",
 'O29' => "Development Planning and Policy: Other",
 'O3' => "Technological Change",
 'O30' => "Technological Change; Research and Development: General",
 'O31' => "Innovation and Invention: Processes and Incentives",
 'O32' => "Management of Technological Innovation and R&D",
 'O33' => "Technological Change: Choices and Consequences; Diffusion Processes (includes impact on production, welfare, income distribution, international competitiveness, military power, measurement, and case studies; international transfer of technology)",
 'O34' => "Intellectual Property Rights: National and International Issues (patents, copyrights)",
 'O38' => "Technological Change: Government Policy",
 'O39' => "Technological Change: Other",
 'O4' => "Economic Growth and Aggregate Productivity",
 'O40' => "Economic Growth and Aggregate Productivity: General (includes data sources)",
 'O41' => "One, Two, and Multisector Growth Models",
 'O42' => "Monetary Growth Models",
 'O47' => "Measurement of Economic Growth; Aggregate Productivity",
 'O49' => "Economic Growth and Aggregate Productivity: Other",
 'O5' => "Economywide Country Studies",
 'O50' => "Economywide Country Studies: General",
 'O51' => "Economywide Country Studies: U.S.; Canada",
 'O52' => "Economywide Country Studies: Europe",
 'O53' => "Economywide Country Studies: Asia including Middle East",
 'O54' => "Economywide Country Studies: Latin America; Caribbean",
 'O55' => "Economywide Country Studies: Africa",
 'O56' => "Economywide Country Studies: Oceania",
 'O57' => "Comparative Studies of Countries",
 'P' => "Economic Systems",
 'P0' => "Economic Systems: General",
 'P00' => "Economic Systems: General",
 'P1' => "Capitalist Systems",
 'P10' => "Capitalist Systems: General",
 'P11' => "Capitalist Systems: Planning, Coordination, and Reform",
 'P12' => "Capitalist Enterprises",
 'P13' => "Cooperative Enterprises",
 'P14' => "Capitalist Systems: Property Rights",
 'P16' => "Capitalist Systems: Political Economy",
 'P17' => "Capitalist Systems: Performance and Prospects",
 'P19' => "Capitalist Systems: Other",
 'P2' => "Socialist Systems and Transitional Economies",
 'P20' => "Socialist Systems and Transitional Economies: General",
 'P21' => "Socialist Systems and Transitional Economies: Planning, Coordination, and Reform",
 'P22' => "Socialist Systems and Transitional Economies: Prices",
 'P23' => "Socialist Systems and Transitional Economies: Factor and Product Markets; Industry Studies; Population (Labor; Capital)",
 'P24' => "Socialist Systems and Transitional Economies: National Income, Product, and Expenditure; Money; Inflation",
 'P25' => "Socialist Systems and Transitional Economies: Urban, Rural, and Regional Economics; Housing; Transportation",
 'P26' => "Socialist Systems and Transitional Economies: Political Economy; Property Rights",
 'P27' => "Socialist Systems and Transitional Economies: Performance and Prospects (includes Spatial)",
 'P28' => "Socialist Systems and Transitional Economies: Natural Resources; Energy; Environment",
 'P29' => "Socialist Systems and Transitional Economies: Other",
 'P3' => "Socialist Institutions and Their Transitions",
 'P30' => "Socialist Institutions and Their Transitions: General",
 'P31' => "Socialist Enterprises and Their Transitions",
 'P32' => "Collectives; Communes; Agriculture",
 'P33' => "Socialist Institutions and Their Transitions: International Trade, Finance, Investment, and Aid",
 'P34' => "Socialist Institutions and Their Transitions: Financial Economics",
 'P35' => "Socialist Institutions and Their Transitions: Public Economics",
 'P36' => "Socialist Institutions and Their Transitions: Consumer Economics; Health, Education, Welfare, and Poverty",
 'P37' => "Socialist Systems and Transitional Economies: Legal Institutions; Illegal Behavior",
 'P39' => "Socialist Institutions and Their Transitions: Other",
 'P4' => "Other Economic Systems",
 'P40' => "Other Economic Systems: General",
 'P41' => "Other Economic Systems: Planning, Coordination, and Reform",
 'P42' => "Other Economic Systems: Productive Enterprises; Factor and Product Markets; Prices; Population",
 'P43' => "Other Economic Systems: Public Economics; Financial Economics",
 'P44' => "Other Economic Systems: National Income, Product, and Expenditure; Money; Inflation",
 'P45' => "Other Economic Systems: International Trade, Finance, Investment and Aid",
 'P46' => "Other Economic Systems: Consumer Economics; Welfare and Poverty",
 'P47' => "Other Economic Systems: Performance and Prospects (includes Spatial)",
 'P48' => "Other Economic Systems: Political Economy; Legal Institutions; Property Rights",
 'P49' => "Other Economic Systems: Other",
 'P5' => "Comparative Economic Systems",
 'P50' => "Comparative Economic Systems: General",
 'P51' => "Comparative Analysis of Economic Systems",
 'P52' => "Comparative Studies of Particular Economies",
 'P59' => "Comparative Economic Systems: Other",
 'Q' => "Agricultural and Natural Resource Economics",
 'Q0' => "Agricultural and Natural Resource Economics: General",
 'Q00' => "Agricultural and Natural Resource Economics; Environmental and Ecological Economics: General",
 'Q01' => "Sustainable Development",
 'Q1' => "Agriculture",
 'Q10' => "Agriculture: General",
 'Q11' => "Agriculture: Aggregate Supply and Demand Analysis; Prices",
 'Q12' => "Micro Analysis of Farm Firms, Farm Households, and Farm Input Markets",
 'Q13' => "Agricultural Markets and Marketing; Cooperatives; Agribusiness",
 'Q14' => "Agricultural Finance",
 'Q15' => "Land Ownership and Tenure; Land Reform; Land Use; Irrigation",
 'Q16' => "Agricultural R&D; Agricultural Technology; Agricultural Extension Services",
 'Q17' => "Agriculture in International Trade",
 'Q18' => "Agricultural Policy; Food Policy",
 'Q19' => "Agriculture: Other",
 'Q2' => "Renewable Resources and Conservation; Environmental Management",
 'Q20' => "Renewable Resources and Conservation: General",
 'Q21' => "Renewable Resources and Conservation: Demand and Supply (the Commons)",
 'Q22' => "Renewable Resources and Conservation: Fishery; Aquaculture",
 'Q23' => "Renewable Resources and Conservation: Forestry",
 'Q24' => "Renewable Resources and Conservation: Land",
 'Q25' => "Renewable Resources and Conservation: Water",
 'Q26' => "Recreational Aspects of Natural Resources",
 'Q28' => "Renewable Resources and Conservation: Government Policy",
 'Q29' => "Renewable Resources and Conservation: Other",
 'Q3' => "Nonrenewable Resources and Conservation",
 'Q30' => "Nonrenewable Resources and Conservation: General",
 'Q31' => "Nonrenewable Resources and Conservation: Demand and Supply",
 'Q32' => "Exhaustible Resources and Economic Development",
 'Q33' => "Resource Booms (Dutch disease)",
 'Q34' => "Natural Resources and Domestic and International Conflicts",
 'Q38' => "Nonrenewable Resources and Conservation: Government Policy (includes OPEC policy)",
 'Q39' => "Nonrenewable Resources and Conservation: Other",
 'Q4' => "Energy",
 'Q40' => "Energy: General",
 'Q41' => "Energy: Demand and Supply",
 'Q42' => "Alternative Energy Sources",
 'Q43' => "Energy and the Macroeconomy",
 'Q48' => "Energy: Government Policy",
 'Q49' => "Energy: Other",
 'Q5' => "Environmental Economics",
 'Q50' => "Environmental Economics: General",
 'Q51' => "Valuation of Environmental Effects (Recreational Effects; Health Effects; Contingent Valuation)",
 'Q52' => "Pollution Control Costs; Distributional Effects; Employment Effects (Firm Behavior)",
 'Q53' => "Air Pollution; Water Pollution; Noise; Hazardous Waste; Solid Waste; Recycling",
 'Q54' => "Climate; Natural Disasters",
 'Q55' => "Environmental Economics: Technological Innovation",
 'Q56' => "Environment and Development; Environment and Trade; Sustainability; Environmental Accounting",
 'Q57' => "Ecological Economics: Ecosystem Services; Biodiversity Conservation; Bioeconomics",
 'Q58' => "Environmental Economics: Government Policy (Environmental Taxes; Tradable Permits; Command and Control; Regulation)",
 'R' => "Urban, Rural, and Regional Economics",
 'R0' => "Urban, Rural, and Regional Economics: General",
 'R00' => "Urban, Rural, and Regional Economics: General",
 'R1' => "General Regional Economics",
 'R10' => "General Regional Economics (includes Regional Data)",
 'R11' => "Regional Economic Activity: Growth, Development, and Changes",
 'R12' => "Size and Spatial Distributions of Regional Economic Activity; Interregional Trade (economic geography)",
 'R13' => "General Equilibrium and Welfare Economic Analysis of Regional Economies",
 'R14' => "Land Use Patterns",
 'R15' => "General Regional Economics: Econometric and Input-Output Models; Other Models",
 'R19' => "General Regional Economics: Other",
 'R2' => "Household Analysis",
 'R20' => "Urban, Rural, and Regional Economics: Household Analysis: General",
 'R21' => "Urban, Rural, and Regional Economics: Housing Demand",
 'R22' => "Urban, Rural, and Regional Economics: Other Demand (spatial analysis)",
 'R23' => "Urban, Rural, and Regional Economics: Regional Migration; Regional Labor Markets; Population",
 'R29' => "Urban, Rural, and Regional Economics: Household Analysis: Other",
 'R3' => "Production Analysis and Firm Location",
 'R30' => "Production Analysis and Firm Location: General",
 'R31' => "Housing Supply and Markets",
 'R32' => "Other Production and Pricing Analysis (spatial analysis firm location decision; industrial districts)",
 'R33' => "Nonagricultural and Nonresidential Real Estate Markets",
 'R34' => "Production Analysis and Firm Location: Input Demand Analysis (spatial)",
 'R38' => "Urban, Rural, and Regional Economics: Production Analysis and Firm Location: Government Policies; Regulatory Policies (Rent Control)",
 'R39' => "Production Analysis and Firm Location: Other",
 'R4' => "Transportation Systems",
 'R40' => "Transportation Systems: General",
 'R41' => "Transportation: Demand, Supply, and Congestion",
 'R42' => "Transportation Systems: Government and Private Investment Analysis",
 'R48' => "Transportation Systems: Government Pricing; Regulatory Policies",
 'R49' => "Transportation Systems: Other",
 'R5' => "Regional Government Analysis",
 'R50' => "Regional Government Analysis: General",
 'R51' => "Finance in Urban and Rural Economies",
 'R52' => "Land Use and Other Regulations",
 'R53' => "Public Facility Location Analysis; Public Investment and Capital Stock",
 'R58' => "Regional Development Policy",
 'R59' => "Regional Government Analysis: Other",
 'Z' => "Other Special Topics",
 'Z0' => "Other Special Topics: General",
 'Z00' => "Other Special Topics: General",
 'Z1' => "Cultural Economics",
 'Z10' => "Cultural Economics: General",
 'Z11' => "Cultural Economics: Economics of the Arts and Literature",
 'Z12' => "Cultural Economics: Religion",
 'Z13' => "Cultural Economics: Social Norms and Social Capital; Social Networks Economic Anthropology",
 'Z19' => "Cultural Economics: Other",

            );

1;

